package io.dyte.core.socket.socketservice

import io.dyte.sockrates.client.WebSocketConnectionState

sealed class SocketServiceConnectionState {
  object Connected : SocketServiceConnectionState()

  data class Disconnected(
    val code: Int,
    val reason: String
  ) : SocketServiceConnectionState()

  // Currently used only for logging purposes
  data class AttemptingReconnect(val attemptNumber: Int) : SocketServiceConnectionState()

  object Reconnecting : SocketServiceConnectionState()

  // Currently used only for logging purposes
  data class ReconnectAttemptFailed(val attemptNumber: Int) : SocketServiceConnectionState()

  object Reconnected : SocketServiceConnectionState()

  object ReconnectFailed : SocketServiceConnectionState()

  companion object {
    @Throws(IllegalArgumentException::class)
    fun createFromSockratesConnectionState(
      webSocketConnectionState: WebSocketConnectionState
    ): SocketServiceConnectionState {
      return when (webSocketConnectionState) {
        is WebSocketConnectionState.AttemptingReconnect -> {
          AttemptingReconnect(webSocketConnectionState.attemptNumber)
        }

        WebSocketConnectionState.Connected -> Connected

        is WebSocketConnectionState.Disconnected -> {
          Disconnected(webSocketConnectionState.code, webSocketConnectionState.reason)
        }

        is WebSocketConnectionState.ReconnectAttemptFailed -> {
          ReconnectAttemptFailed(webSocketConnectionState.attemptNumber)
        }

        WebSocketConnectionState.ReconnectFailed -> ReconnectFailed

        WebSocketConnectionState.Reconnected -> Reconnected

        WebSocketConnectionState.Reconnecting -> Reconnecting

        else -> {
          throw IllegalArgumentException("$webSocketConnectionState connection state not supported")
        }
      }
    }
  }
}