package io.dyte.core.platform

import io.dyte.core.controllers.Permission
import io.dyte.core.controllers.PermissionType

interface IDytePlatformPermissionUtils {
  fun isPermissionGranted(permission: Permission): Boolean
  fun arePermissionsGranted(permissions: List<Permission>): Boolean
  fun askPermissions(permissions: List<Permission>, onPermissionsGranted: () -> Unit, onPermissionsDenied: () -> Unit): Boolean
  fun askCameraPermissions(onPermissionsGranted: () -> Unit, onPermissionsDenied: () -> Unit): Boolean {
    // Returning false we are not handling this methods
    return false
  }
  fun askAudioPermissions(onPermissionsGranted: () -> Unit, onPermissionsDenied: () -> Unit) : Boolean {
    // Returning false we are not handling this methods
    return false
  }

}

