package io.dyte.core.network.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class MeetingSessionDataWrapper(
  val success: Boolean,
  val data: MeetingSessionData
)

@Serializable
data class MeetingSessionData(
  @SerialName("title") val title: String? = null,
  @SerialName("room_node_link") val roomNodeLink: String? = null
)

/**
 * {
"data": {
"session": {
"title": "Monday Sprint Planning",
"roomNodeLink": "https://room-node-ap-south-1-0.cluster.dyte.in",
"roomName": "tpzroe-lztvyk",
"password": null
}
}
}
 */
@Serializable
data class MeetingSessionDataResponseV1(
  val data: MeetingSessionDataWrapperV1
)

@Serializable
data class MeetingSessionDataWrapperV1(
  val session: MeetingSessionData
)
