package io.dyte.core.feat

import io.dyte.core.controllers.IControllerContainer
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.newSingleThreadContext

class DyteWebinar internal constructor(private val controllerContainer: IControllerContainer) {
  private  val serialScope = CoroutineScope(newSingleThreadContext("DyteWebinar"))
  fun requestToJoin() {
    serialScope.launch {
      controllerContainer.webinarController.joinStage()
    }
  }

  fun leaveStage() {
    serialScope.launch {
      controllerContainer.webinarController.leaveStage()
    }
  }

  fun acceptRequestToPresent() {
    serialScope.launch {
      controllerContainer.webinarController.acceptRequestToPresent()
    }
  }

  fun rejectRequestToPresent() {
    serialScope.launch {
      controllerContainer.webinarController.rejectRequestToPresent()
    }
  }

  fun acceptRequest(id: String) {
    serialScope.launch {
      controllerContainer.webinarController.acceptRequest(id)
    }
  }

  fun acceptAllRequest() {
    serialScope.launch {
      controllerContainer.webinarController.acceptAllRequest()
    }
  }

  fun rejectRequest(id: String) {
    serialScope.launch {
      controllerContainer.webinarController.rejectRequest(id)
    }
  }

  fun rejectAllRequest() {
    serialScope.launch {
      controllerContainer.webinarController.rejectAllRequest()
    }
  }

  fun isPresenting(): Boolean {
    return controllerContainer.metaController.isGroupCall() || (controllerContainer.metaController.isWebinar() && controllerContainer.webinarController.isPresenting())
  }
}