package io.dyte.core.feat

import io.dyte.core.controllers.Controller
import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.controllers.LiveStreamState

class DyteLiveStream internal constructor(private val controller: Controller) {
  val liveStreamUrl: String?
    get() = controller.liveStreamController.liveStreamUrl
  val state: LiveStreamState
    get() = controller.liveStreamController.state
  val roomName: String
    get() = controller.metaController.getMeetingTitle()

  fun start() {
    controller.liveStreamController.start()
  }

  fun stop() {
    controller.liveStreamController.stop()
  }
}