package io.dyte.core.network.models

import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserDataWrapper(
  val success: Boolean,
  val data: ParticipantDataWrapper
)

@Serializable
data class UserDataWrapperV1(
  val user: ParticipantData
)

@Serializable
data class ParticipantDataWrapper(
  val participant: ParticipantData,
  val preset: ParticipantPreset
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class ParticipantData(
  val id: String,
  val name: String,
  @JsonNames("custom_participant_id") val clientSpecificId: String,
  @JsonNames("organization_id") val organizationId: String,
  val picture: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class ParticipantPreset(
  val id: String,
  @JsonNames("created_at") val createdAt: String,
  @JsonNames("updated_at") val updateAt: String,
  val name: String,
  val permissions: ParticipantPresetPermission,
  val ui: UserPresetUI,
  val config: ParticipantPresetConfig
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class ParticipantPresetPermission(
  @JsonNames("accept_waiting_requests") val acceptWaitingRequests: Boolean,
  @JsonNames("disable_participant_audio") val disableParticipantAudio: Boolean,
  @JsonNames("disable_participant_screensharing") val disableParticipantScreenSharing: Boolean,
  @JsonNames("disable_participant_video") val disableParticipantVideo: Boolean,
  @JsonNames("kick_participant") val kickParticipant: Boolean,
  @JsonNames("pin_participant") val pinParticipant: Boolean,
  @JsonNames("can_record") val canRecord: Boolean,
  @JsonNames("waiting_room_type") val waitingRoomType: String,
  val plugins: ParticipantPluginPreset,
  val polls: ParticipantPollPreset,
  val media: ParticipantMediaPreset,
  val chat: ParticipantChatPreset,
  @JsonNames("hidden_participant") val hiddenParticipant: Boolean,
  @JsonNames("show_participant_list") val showParticipantList: Boolean,
  @SerialName("can_edit_display_name") val canEditDisplayName: Boolean
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class ParticipantPluginPreset(
  @JsonNames("can_close") val canClose: Boolean,
  @JsonNames("can_start") val canStart: Boolean
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class ParticipantPollPreset(
  @JsonNames("can_create") val canCreate: Boolean,
  @JsonNames("can_vote") val canVote: Boolean,
  @JsonNames("can_view") val canView: Boolean
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class ParticipantMediaPreset(
  val video: MediaPreset,
  val audio: MediaPreset,
  val screenshare: MediaPreset
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class MediaPreset(
  @JsonNames("can_produce") val canProduce: String
)

@Serializable
data class ParticipantChatPreset(
  val public: PublicChatPreset,
  val private: PrivateChatPreset
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class PublicChatPreset(
  @JsonNames("can_send") val canSend: Boolean,
  val text: Boolean,
  val files: Boolean
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class PrivateChatPreset(
  @JsonNames("can_send") val canSend: Boolean,
  @JsonNames("can_receive") val canReceive: Boolean,
  val text: Boolean,
  val files: Boolean
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class ParticipantPresetConfig(
  @JsonNames("view_type") val viewType: String,
  val media: MediaConfig,
  @JsonNames("max_video_streams") val streamsConfig: VideoStreamConfig,
  @JsonNames("max_screenshare_count") val maxScreenShareCount: Int
)

@Serializable
data class MediaConfig(
  val video: VideoConfig,
  val screenshare: VideoConfig
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class VideoConfig(
  val quality: String,
  @JsonNames("frame_rate") val frameRate: Int
)

@Serializable
data class VideoStreamConfig(
  val mobile: Int,
  val desktop: Int
)

@Serializable
data class UserPresetUI(
  @SerialName("design_tokens")
  val designTokens: UserPresetDesignToken
)

@Serializable
data class UserPresetDesignToken(
  @SerialName("border_radius") val borderRadius: BorderRadiusType,
  @SerialName("border_width") val borderWidth: BorderWidthType,
  @SerialName("spacing_base") val spacingBase: Int,
  val theme: String,
  val colors: UserPresetDesignColors
)

@Serializable
data class UserPresetDesignColors(
  val brand: Map<String, String>,
  val background: Map<String, String>,
  val danger: String,
  val text: String,
  @SerialName("text_on_brand") val textOnBrand: String,
  val success: String,
  @SerialName("video_bg") val videoBg: String,
  val warning: String,
)

@Serializable
enum class BorderRadiusType {
  @SerialName("rounded")
  ROUNDED,

  @SerialName("sharp")
  SHARP,

  @SerialName("extra-rounded")
  EXTRA_ROUNDED,

  @SerialName("circular")
  CIRCULAR;
}

@Serializable
enum class BorderWidthType {
  @SerialName("none")
  NONE,

  @SerialName("thin")
  THIN,

  @SerialName("fat")
  FAT;
}

