package io.dyte.core.network.models

import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class GraphQlRequest(
  @JsonNames("query")
  val query: String,

  @JsonNames("variables")
  val variables: GraphQlRequestVariables
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class GraphQlRequestVariables(
  @JsonNames("roomName")
  val roomName: String,

  @JsonNames("password")
  val password: String,

  val ipInformation: String
)