package io.dyte.core.network.models

import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

@Serializable
data class CreateMeetingResponseWrapper(
  val success: Boolean,
  val data: CreateMeetingResponse
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class CreateMeetingResponse(
  val id: String,
  val title: String,
  @JsonNames("created_at") val createdAt: String,
  @JsonNames("updated_at") val updatedAt: String,
  @JsonNames("waiting_room") val waitingRoom: Boolean
)