package io.dyte.core.network.models

import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

@Serializable
data class CreateParticipantResponseWrapper(
  val success: Boolean,
  val data: CreateParticipantResponse
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class CreateParticipantResponse(
  val id: String,
  val name: String,
  @JsonNames("client_specific_id") val clientSpecificId: String,
  @JsonNames("preset_id") val presetId: String,
  @JsonNames("created_at") val createdAt: String,
  @JsonNames("updated_at") val updatedAt: String,
  val token: String
)
