package io.dyte.core.cameramanager

import android.content.Context
import android.hardware.camera2.CameraCharacteristics
import android.hardware.camera2.CameraManager
import io.dyte.core.models.DyteVideoDevice
import io.dyte.core.models.VideoDeviceType.EXTERNAL
import io.dyte.core.models.VideoDeviceType.FRONT
import io.dyte.core.models.VideoDeviceType.REAR

internal class DyteCameraManager(private val context: Context) {
  val cameraManager = context.getSystemService(Context.CAMERA_SERVICE) as CameraManager

  fun getCameraDevices(): List<DyteVideoDevice> {
    val devices = arrayListOf<DyteVideoDevice>()
    cameraManager.cameraIdList.forEach { cameraId ->
      val cameraCharacteristics = cameraManager.getCameraCharacteristics(cameraId)
      val lensFacing = cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) ?: -1
      when (lensFacing) {
        CameraCharacteristics.LENS_FACING_FRONT -> {
          devices.add(DyteVideoDevice(cameraId, FRONT))
        }

        CameraCharacteristics.LENS_FACING_BACK -> {
          devices.add(DyteVideoDevice(cameraId, REAR))
        }

        CameraCharacteristics.LENS_FACING_EXTERNAL -> {
          devices.add(DyteVideoDevice(cameraId, EXTERNAL))
        }
      }
    }
    return devices
  }
}