package io.dyte.core.platform

import io.dyte.core.controllers.PermissionType
import kotlinx.coroutines.Job

interface IDytePlatformUtils {
  fun getCurrentTime(): Long
  fun getUuid(): String
  fun printThread(desc: String? = null)

  fun getAndroidApplicationContext(): Any
  fun getActivity(): Any

  // "yyyy-MM-dd'T'HH:mm:ss'Z'"
  fun getDiff(startTime: String, endTime: String): String

  // "YYYY-MM-DDThh:mm:ss.sTZD"
  fun getUtcTimeNow(): String

  fun getUserDisplayableTime(time: Long): String

  /**
   * Returns the entire content of the file as a byte array.
   *
   * @param filePath to the File on device
   */
  fun getFileContent(filePath: String): ByteArray

  fun listenForCrashes()

  fun getOsName(): String
  fun getOsVersion(): String
  fun getDeviceInfo(): String

  // samsung, LG, MI, motorola, google
  fun getDeviceModel(): String

  // android, iOS
  fun getDeviceType(): String

  // android core, android ui kit, iOS core, iOS ui kit, flutter core, flutter ui kit
  fun getSdkType(): String

  fun getBatteryLevel(): String

  fun decodeAuthToken(authToken: String): String?

  fun getUrlEncodedString(stringToEncode: String): String

  fun getPlatformFile(path: String): PlatformFile?

  fun getPlatformFile(uri: Uri): PlatformFile?
}

expect class Uri