package io.dyte.core.feat

import io.dyte.core.controllers.IControllerContainer

class DyteWebinar internal constructor(private val controllerContainer: IControllerContainer) {
  fun requestToJoin() {
    controllerContainer.webinarController.joinStage()
  }

  fun leaveStage() {
    controllerContainer.webinarController.leaveStage()
  }

  fun acceptRequestToPresent() {
    controllerContainer.webinarController.acceptRequestToPresent()
  }

  fun rejectRequestToPresent() {
    controllerContainer.webinarController.rejectRequestToPresent()
  }

  fun acceptRequest(id: String) {
    controllerContainer.webinarController.acceptRequest(id)
  }

  fun acceptAllRequest() {
    controllerContainer.webinarController.acceptAllRequest()
  }

  fun rejectRequest(id: String) {
    controllerContainer.webinarController.rejectRequest(id)
  }

  fun rejectAllRequest() {
    controllerContainer.webinarController.rejectAllRequest()
  }

  fun isPresenting(): Boolean {
    return controllerContainer.metaController.isGroupCall() || (controllerContainer.metaController.isWebinar() && controllerContainer.webinarController.isPresenting())
  }
}