package io.dyte.core.platform

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.network.models.IceServerData
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketConsumerClosedModel
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketConsumerModel
import io.dyte.core.socket.events.payloadmodel.outbound.WebRtcCreateTransportModel

internal interface IDyteMediaSoupUtils : IDyteSFUUtils {
  fun init(controllerContainer: IControllerContainer)

  fun loadRouterRtpCapabilities(routerRtpCapabilitiesString: String)
  fun createWebRtcTransportRecv(
    model: WebRtcCreateTransportModel,
    iceServers: List<IceServerData>
  )

  fun createWebRtcTransportProd(
    model: WebRtcCreateTransportModel,
    iceServers: List<IceServerData>
  )

  fun connectTransport(id: String, producing: Boolean)

  fun handleNewConsumer(
    webSocketConsumerModel: WebSocketConsumerModel,
    onDone: () -> Unit
  )

  fun handleCloseConsumer(webSocketConsumerModel: WebSocketConsumerClosedModel)
  fun resumeConsumer(id: String)

  fun getSelfTrack(): Pair<Any?, Any?>

  fun onCameraStreamKilled()
}
