package io.dyte.core.models

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.controllers.PermissionType.CAMERA
import io.dyte.core.controllers.PermissionType.MICROPHONE
import io.dyte.core.feat.DyteMeetingParticipant
import io.dyte.core.feat.ParticipantFlags
import io.dyte.core.models.WaitListStatus.NONE

// TODO : add enabledPreview, disablePreview
// TODO : getAudioDevices, getVideoDevices, getSpeakerDevices, getDeviceBydId, getAllDevices, setDevice
// TODO : setIsPinned, pin, unpin,
// TODO : add roomJoined, remove userId
// TODO : wrap audioTrack and videoTrack inside preview
// TODO : we can get rid of audioTrack, its not been used anywhere.
class DyteSelfParticipant internal constructor(
  override val id: String,
  override val userId: String,
  override var name: String,
  override val picture: String?,
  override val isHost: Boolean,
  override val clientSpecificId: String?,
  override val flags: ParticipantFlags,
  controllerContainer: IControllerContainer
) : DyteMeetingParticipant(
  id, userId, name, picture,
  isHost, clientSpecificId, flags, controllerContainer
) {
  val permissions = controllerContainer.presetController.permissions

  internal var _waitListStatus: WaitListStatus = NONE
  val waitListStatus: WaitListStatus
    get() = _waitListStatus

  internal var _cameraPermissionGranted: Boolean = controllerContainer.permissionController.isPermissionGrated(CAMERA)
  val isCameraPermissionGranted: Boolean
    get() = _cameraPermissionGranted

  internal var _microphonePermissionGranted: Boolean = controllerContainer.permissionController.isPermissionGrated(MICROPHONE)
  val isMicrophonePermissionGranted: Boolean
    get() = _microphonePermissionGranted

  val roomJoined: Boolean
    get() = controllerContainer.selfController.roomJoined

  /**
   * This method is used to unmute the local participant's audio.
   */
  fun enableAudio() {
    controllerContainer.selfController.enableAudio()
  }

  /**
   * This method is used to mute the local participant's audio.
   */
  override fun disableAudio() {
    return controllerContainer.selfController.disableAudio()
  }

  /**
   * This method is used to start streaming the local participant's video to the meeting.
   */
  fun enableVideo() {
    return controllerContainer.selfController.enableVideo()
  }

  /**
   * This participant is used to disable the local participant's video.
   */
  override fun disableVideo() {
    return controllerContainer.selfController.disableVideo()
  }

  fun setDisplayName(name: String) {
    this.name = name
  }

  fun getAudioDevices(): List<DyteAudioDevice> {
    return controllerContainer.selfController.getAudioDevices()
  }

  fun getVideoDevices(): List<DyteVideoDevice> {
    return controllerContainer.selfController.getVideoDevices()
  }

  fun setAudioDevice(dyteAndroidDevice: DyteAudioDevice) {
    controllerContainer.selfController.setDevice(dyteAndroidDevice)
  }

  fun setVideoDevice(dyteVideoDevice: DyteVideoDevice) {
    controllerContainer.selfController.setDevice(dyteVideoDevice)
  }

  fun getSelectedVideoDevice(): DyteVideoDevice {
    return controllerContainer.selfController.getSelectedVideoDevice()
  }

  fun getSelectedAudioDevice(): DyteAudioDevice {
    return controllerContainer.selfController.getSelectedAudioDevice()
  }

  fun canDoParticipantHostControls(): Boolean =
    controllerContainer.presetController.canDoParticipantHostControls()

  fun shouldShowSetupScreen(): Boolean {
    return permissions.media.canPublishAudio || permissions.media.canPublishVideo
  }

  override fun toMap(): Map<String, Any?> {
    val map = HashMap(super.toMap())
    map["selfPermissions"] = permissions.toMap()
    return map
  }
}