package io.dyte.core.listeners

/**
 * Dyte meeting room events listener
 *
 * You can subscribe to all room events by implementing this interface.
 * To subscribe pass implementation to [io.dyte.core.DyteMobileClient.addMeetingRoomEventsListener]
 */
interface DyteMeetingRoomEventsListener {
  fun onMeetingInitStarted() {}
  fun onMeetingInitCompleted() {}
  fun onMeetingInitFailed(exception: Exception) {}

  /**
   * On meeting room join started
   * Triggered once the sdk starts making connection to the roomname you passed.
   * Ideally one should show loader on UI once this event is triggered.
   */
  fun onMeetingRoomJoinStarted() {}
  fun onMeetingRoomJoinCompleted() {}
  /**
   * On meeting room join failed
   * Triggered when some error happended while executing [io.dyte.core.DyteMobileClient.joinRoom]
   * or [io.dyte.core.DyteMobileClient.init]
   * @param exception - actual exception. This can be either http exception or any android exception
   */
  fun onMeetingRoomJoinFailed(exception: Exception) {}

  fun onMeetingRoomLeaveStarted() {}
  /**
   * On meeting room left
   * Triggered once this user is left successfully from the meeting
   */
  fun onMeetingRoomLeaveCompleted() {}

  /**
   * When connection to meeting room is lost due to network conditions
   */
  fun onMeetingRoomDisconnected() {}
}