package io.dyte.core.feat

import io.dyte.core.controllers.Controller
import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.controllers.LiveStreamState

class DyteLiveStream internal constructor(private val controller: Controller) {

  fun getLiveStreamUrl(): String? {
    return controller.liveStreamController.liveStreamUrl
  }

  fun start() {
    controller.liveStreamController.start()
  }

  fun stop() {
    controller.liveStreamController.stop()
  }

  fun getState(): LiveStreamState {
    return controller.liveStreamController.state
  }
}