package io.dyte.core

import android.content.Context
import android.util.AttributeSet
import android.widget.LinearLayout
import io.dyte.core.feat.DyteMeetingParticipant
import io.dyte.core.controllers.IControllerContainer
import org.webrtc.EglBase
import org.webrtc.RendererCommon.ScalingType.SCALE_ASPECT_FIT
import org.webrtc.SurfaceViewRenderer
import org.webrtc.VideoTrack

class VideoView : LinearLayout {
  private var participant: DyteMeetingParticipant? = null
  private var videoRenderer: SurfaceViewRenderer? = null
  private var controllerContainer: IControllerContainer? = null

  constructor(context: Context) : super(context) {
    init(context)
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init(context)
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init(context)
  }

  private fun init(context: Context) {
    inflate(context, R.layout.view_video, this)
    videoRenderer = findViewById(R.id.video_renderer)
  }

  internal fun setup(
    controllerContainer: IControllerContainer,
    dyteParticipant: DyteMeetingParticipant
  ) {
    this.participant = dyteParticipant
    this.controllerContainer = controllerContainer
    activate()
  }

  private fun activate() {
    videoRenderer?.setScalingType(SCALE_ASPECT_FIT)
    videoRenderer?.init(
      requireNotNull(controllerContainer).platformUtilsProvider.getPeerConnectionUtils()
        .getEglContext() as EglBase.Context, null
    )
  }

  fun renderVideo() {
    try {
      var track: VideoTrack? = null
      if (participant?.videoEnabled == true && participant?.videoTrack is VideoTrack) {
        track = participant?.videoTrack as VideoTrack
      }

      if (track != null) {
        videoRenderer?.visibility = VISIBLE
        track.removeSink(videoRenderer)
        track.addSink(videoRenderer)
      } else {
        videoRenderer?.visibility = GONE
      }
    } catch (e:Exception) {
      e.printStackTrace()
    }
  }

  fun renderScreenShare() {
    var track: VideoTrack? = null
    if (participant?._screenShareTrack != null) {
      track = participant?.screenShareTrack as VideoTrack
    }

    if (track != null) {
      videoRenderer?.visibility = VISIBLE
      track.removeSink(videoRenderer)
      track.addSink(videoRenderer)
    } else {
      videoRenderer?.visibility = GONE
    }
  }

  fun release() {
    if (participant?.videoEnabled == true && participant?.videoTrack is VideoTrack) {
      val track = participant?.videoTrack as VideoTrack?
      track?.removeSink(videoRenderer)
    }
    if (participant?._screenShareTrack != null) {
      val track = participant?.screenShareTrack as VideoTrack?
      track?.removeSink(videoRenderer)
    }
  }
}