package io.dyte.core.socket.socketservice

/*
Note(swapnil): These Event enums will be moved to their respective Socket Handler classes once
Socket-service integration is complete with at least 1 feature (Chat).
*/
internal object SocketServiceUtils {
  enum class RoomEvent(slug: Int) {
    GET_PEER_INFO(0),
    UPDATE_PEER_INFO(1),
    GET_ROOM_PEERS_INFO(2),
    JOIN_ROOM(3),
    LEAVE_ROOM(4),
    GET_ROOM_INFO(5),
    UPDATE_ROOM_INFO(6),
    CLOSE_ROOM(7),
    STARTED(8),
    STOPPED(9),
    ERRORED(10);

    private val base: Int = 0
    val id: Int = generateSocketEventId(base, slug)
  }

  /**
   * Generates a 32-bit int event id that our Socket Service understands.
   * First byte is 0 which tells the Socket service that this event is a socket event
   * (room, chat, polls, plugin).
   *
   * 1. Convert [eventBase] to 32 bit Binary form
   * 2. Shift value to left by 16 bits
   * 3. Add [slug] to Decimal form of new value from step 2
   *
   * @return eventId a 32-bit int
   */
  fun generateSocketEventId(eventBase: Int, slug: Int): Int {
    val eventId = (eventBase shl 16) + slug
    return eventId
  }

  enum class MediaEvent(slug: Int) {
    UNKNOWN(0),
    CREATE_WEBRTC_TRANSPORT(1),
    PRODUCE(2),
    CONSUME(3),
    TOGGLE_PRODUCER(4),
    TOGGLE_CONSUMER(5),
    CLOSE_PRODUCER(6),
    CLOSE_CONSUMER(7),

    // adding some buffers for new media events.
    JOIN_ROOM(16),
    LEAVE_ROOM(17),
    SELECTED_PEER(18),
    GLOBAL_PIN_PEER(19),
    TRICKLE_ICE_CANDIDATE(20),

    // some additional buffer for broadcast events.
    PEER_JOINED_BROADCAST(25),
    PEER_LEAVE_BROADCAST(26),
    PEER_PRODUCER_CREATE_BROADCAST(27),
    PEER_PRODUCER_TOGGLE_BROADCAST(28),
    PEER_PRODUCER_CLOSE_BROADCAST(29),
    GLOBAL_PEER_PIN_BROADCAST(30),
    PEER_CONSUMER_TOGGLE_BROADCAST(31),

    // some additional buffer
    SELECTED_PEER_DIFF(40),
    RENEGOTIATE_SESSION_DESCRIPTION(50);

    val id: Int = generateMediaEventId(slug)
  }

  /**
   * Generates a 32-bit int event id that our Socket Service understands.
   * First byte is 1 which tells the Socket service that this event is a media event.
   *
   * @return eventId a 32-bit int
   */
  fun generateMediaEventId(slug: Int): Int {
    val eventId = (0x01000000 or slug)
    return eventId
  }
}