package io.dyte.core.socket.events.payloadmodel.inbound

import io.dyte.core.socket.events.InboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import kotlinx.serialization.Serializable

/**
 * response for event [InboundMeetingEventType.WEB_SOCKET_CONNECT_TRANSPORT]
 */
@Serializable
data class WebSocketPollsModel(
  val polls: Map<String, WebSocketPoll>? = null
) : BasePayloadModel()

@Serializable
data class WebSocketPollModel(
  val poll: WebSocketPoll
) : BasePayloadModel()

@Serializable
data class WebSocketPoll(
  val id: String,
  val options: List<WebSocketPollOption>,
  val question: String,
  val anonymous: Boolean,
  val hideVotes: Boolean,
  val createdBy: String
)

@Serializable
data class WebSocketPollOption(
  val text: String,
  val votes: List<WebSocketPollVote>,
  val count: Int
)

@Serializable
data class WebSocketPollVote(
  val id: String,
  val name: String
)
