package io.dyte.core.socket.events.payloadmodel.inbound

import io.dyte.core.socket.events.InboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

/**
 * response for event [InboundMeetingEventType.WEB_SOCKET_PEER_JOINED]
 */
@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class WebSocketMeetingPeerUser(
  @SerialName("id")
  var id: String? = null,

  @SerialName("userId")
  var userId: String? = null,

  @JsonNames("name", "displayName")
  var name: String? = null,

  @SerialName("device")
  var device: Device? = null,

  @SerialName("picture")
  var picture: String? = null,

  @SerialName("isHost")
  var isHost: Boolean? = null,

  @SerialName("webinarHiddenParticipant")
  var webinarHiddenParticipant: Boolean? = null,

  @SerialName("flags")
  var flags: MeetingPeerFlags? = null,

  @SerialName("clientSpecificId")
  var clientSpecificId: String? = null,

  @SerialName("audioMuted")
  var audioMuted: Boolean? = null,

  @SerialName("hiddenParticipant")
  var hiddenParticipant: Boolean? = null
) : BasePayloadModel()

@Serializable
data class Device(
  @SerialName("isMobile")
  var isMobile: Boolean = false,

  @SerialName("sdkName")
  var sdkName: String? = null,

  @SerialName("browserName")
  var browserName: String? = null,

  @SerialName("osName")
  var osName: String? = null,

  @SerialName("browserVersion")
  var browserVersion: String? = null,

  @SerialName("osVersionName")
  var osVersionName: String? = null,

  @SerialName("engineName")
  var engineName: String? = null,
)

@Serializable
data class MeetingPeerFlags(
  @SerialName("hiddenParticipant")
  var hiddenParticipant: Boolean? = null,

  @SerialName("recorder")
  var recordere: Boolean? = null
)

@Serializable
data class MeetingPeerMetadata(
  @SerialName("view_type")
  var viewType: String?
)