package io.dyte.callstats.media

import io.dyte.media.Consumer
import io.dyte.media.hive.HiveConsumer

class ConsumerFacade(
  private val isHive: Boolean,
  private val mediasoupConsumer: Consumer? = null,
  private val hiveConsumer: HiveConsumer? = null,
) {
  fun getId(): String {
    return if (isHive) hiveConsumer!!.getId() else mediasoupConsumer!!.id
  }

  fun getAppData(): Map<String, Any> {
    return if (isHive) hiveConsumer!!.getAppData() ?: emptyMap() else mediasoupConsumer!!.appData
  }

  fun getProducerId(): String {
    return if (isHive) hiveConsumer!!.getProducerId() else mediasoupConsumer!!.producerID
  }

  fun getSsrc(): Long? {
    return if (isHive) hiveConsumer!!.getSsrc()
    else mediasoupConsumer!!.rtpParameters.encodings?.first()?.ssrc
  }
}
