package io.dyte.callstats.api

import io.dyte.callstats.IPDetails
import io.ktor.client.call.*
import io.ktor.client.request.*
import io.ktor.client.statement.*
import io.ktor.http.HttpStatusCode
import kotlinx.serialization.decodeFromString

class IPApiService : BaseApiService() {
  suspend fun getIpDetails(): IPDetails {
    val locationResponse = client.get(LOCATION_ENDPOINT)
    if (locationResponse.status == HttpStatusCode.OK) {
      try {
        return json.decodeFromString<IPDetails>(locationResponse.bodyAsText())
      } catch (e: Exception) {
        // ignore parsing error
      }
    }

    val locationLegacyResponse = client.post(LOCATION_LEGACY_ENDPOINT)
    if (locationLegacyResponse.status == HttpStatusCode.OK) {
      try {
        return json.decodeFromString<IPDetails>(locationLegacyResponse.bodyAsText())
      } catch (e: Exception) {
        // ignore parsing error
      }
    }

    return IPDetails()
  }

  companion object {
    private const val LOCATION_ENDPOINT = "https://location.dyte.io"
    private const val LOCATION_LEGACY_ENDPOINT =
      "https://location-legacy.dyte.io/?token=3c493932b0624c"
  }
}
