package io.dyte.callstats.platform

import platform.Foundation.NSProcessInfo
import platform.UIKit.UIDevice

actual class PlatformInfo {

  actual fun getOSName(): String {
    return UIDevice.currentDevice.systemName
  }

  actual fun getOSVersionName(): String {
    return UIDevice.currentDevice.systemVersion
  }

  actual fun getUserAgent(): String {
    return "${UIDevice.currentDevice.systemName}-${UIDevice.currentDevice.systemVersion}"
  }

  actual fun getCpuCount(): Int {
    return NSProcessInfo.processInfo.activeProcessorCount.toInt()
  }

  actual fun getTotalMemory(): Long {
    return NSProcessInfo.processInfo.physicalMemory.toLong()
  }
}
