package io.dyte.callstats.models

import io.dyte.callstats.IceServerInfo
import io.dyte.callstats.events.EventChunk
import io.dyte.webrtc.IceServer
import kotlinx.serialization.Serializable

data class AuthPayload(val peerId: String)

data class RegionalIceInformation(val regionId: String, val iceServers: List<IceServerInfo>)

data class ParsedIceCandidate(
  val type: String,
  val protocol: String,
  val address: String,
)

data class DataThroughputTestResults(
  val RTT: Long,
  val backendRTT: Long,
  val throughput: Long,
)

data class RTTStats(val rtt: Long, val backendRTT: Long)

data class TestResult(val connectivity: Boolean)

@Serializable data class SQSPacketStructure(val payload: EventChunk, val peerId: String)

data class AWSCredentials(val accessKeyId: String, val secretAccessKey: String)

data class SQSClientConfig(val region: String, val credentials: AWSCredentials, val queue: String?)

@Serializable data class IceServersWrapper(val iceServers: List<IceServerData>)

@Serializable
data class IceServerData(
  val url: String,
  val username: String? = null,
  val credential: String? = null,
  val credentialType: String? = null
)

fun IceServersWrapper.toPcIceServers(): List<IceServer> {
  val pcIceServers = mutableListOf<IceServer>()
  for (iceServer in iceServers) {
    if (iceServer.username != null && iceServer.credential != null) {
      pcIceServers.add(
        IceServer(
          username = iceServer.username,
          password = iceServer.credential,
          urls = listOf(iceServer.url)
        )
      )
    }
  }

  return pcIceServers
}
