package io.dyte.callstats

import io.dyte.callstats.observers.TestObserver
import io.dyte.webrtc.RtcStatsReport

interface Measurements<ProducerType, ConsumerType, TransportType, IceServerType> {
  suspend fun registerProducer(producer: ProducerType)

  fun processInboundConsumerVideoStats(
    consumerId: String,
    overallConsumerStatsValue: OverallConsumerStatsValue,
    streamStatsData: InboundVideoStreamStats,
  )

  fun processInboundConsumerAudioStats(
    consumerId: String,
    overallConsumerStatsValue: OverallConsumerStatsValue,
    streamStatsData: InboundAudioStreamStats,
  )

  suspend fun registerConsumer(consumer: ConsumerType)

  suspend fun generateProducerStreamMap(
    producer: ProducerType,
    parse: Boolean = false,
  ): ProducerStatistics?

  suspend fun generateConsumerStreamMap(
    consumer: ConsumerType,
    parse: Boolean = false,
  ): ConsumerStatistics?

  fun deregisterProducer(producer: ProducerType)

  fun deregisterConsumer(consumer: ConsumerType)

  fun parseRTCReport(
    statsList: List<RtcStatsReport>,
    statsTypeFilter: List<String> = emptyList(),
    ownerId: String? = null,
  ): ParsedRTCStats

  suspend fun getProducersReport(producers: List<ProducerType>): List<ProducerStatistics>

  suspend fun getConsumersReport(consumers: List<ConsumerType>): List<ConsumerStatistics>

  suspend fun getTransportReport(transport: TransportType): List<RtcStatsReport>

  suspend fun getProcessedStats(
    transport: TransportType,
    consuming: Boolean,
    producing: Boolean,
  ): ProcessedStatsReport?

  fun getProducerStatsFromReport(report: ParsedRTCStats): List<ProducerStatistics>

  fun getConsumerStatsFromReport(report: ParsedRTCStats): List<ConsumerStatistics>

  suspend fun getConnectivity(iceServers: List<IceServerType>, observer: TestObserver)

  suspend fun getThroughput(iceServers: List<IceServerType>, observer: TestObserver)

  suspend fun getIpDetails(): IPDetails

  suspend fun getNetworkQuality(iceServers: List<IceServerType>, observer: TestObserver)

  suspend fun getNetworkInfo(iceServers: List<IceServerType>, observer: TestObserver)
}
