package io.dyte.callstats.api

import io.ktor.client.HttpClient
import io.ktor.client.plugins.logging.*
import kotlinx.serialization.json.Json

private const val BASE_URL = "https://api.staging.dyte.in/"

open class BaseApiService {
  internal val client: HttpClient = HttpClient()

  fun getUrl(endpoint: String): String {
    return "$BASE_URL$endpoint"
  }

  companion object {
    val json = Json {
      ignoreUnknownKeys = true
      encodeDefaults = true
      prettyPrint = true
    }
  }
}
