package io.dyte.callstats.events

import io.dyte.callstats.utils.Logger

typealias NoData = String

class InternalEventsHandler(private val logger: Logger) {
  private val eventsToFns: MutableMap<InternalEvents, MutableList<Pair<(Any) -> Unit, String?>>> =
    mutableMapOf()

  fun on(event: InternalEvents, callback: (Any) -> Unit, tag: String?) {
    if (eventsToFns.containsKey(event)) {
      eventsToFns[event]!!.add(Pair(callback, tag))
    } else {
      eventsToFns[event] = mutableListOf(Pair(callback, tag))
    }
  }

  fun emit(event: InternalEvents, data: Any, tag: String?) {
    if (eventsToFns.containsKey(event)) {
      val cbList = eventsToFns[event]!!
      for ((cb, t) in cbList) {
        if (t == tag) {
          cb.invoke(data)
        }
      }
    } else {
      this.logger.log("Event $event not found")
    }
  }
}
