package io.dyte.callstats.platform

actual class PlatformInfo {

  actual fun getOSName(): String {
    return "Android"
  }

  actual fun getOSVersionName(): String {
    return android.os.Build.VERSION.RELEASE
  }

  actual fun getUserAgent(): String {
    return "android-${android.os.Build.VERSION.SDK_INT}"
  }

  actual fun getCpuCount(): Int {
    return Runtime.getRuntime().availableProcessors()
  }

  actual fun getTotalMemory(): Long {
    return Runtime.getRuntime().totalMemory()
  }
}
