package io.dyte.callstats.observers

import io.dyte.callstats.IPDetails
import io.dyte.callstats.events.EventData

interface CallStatsObserver {
  fun onInitialized(ipDetails: IPDetails)
  fun onError(ex: Exception)
  fun onAudioOffEntry(data: EventData)
  fun onAudioOnEntry(data: EventData)
  fun onAudioPlaybackFailureEntry(data: EventData)
  fun onAudioTrackFailureEntry(data: EventData)
  fun onCallJoinBeginEntry(data: EventData)
  fun onDisconnectEntry(data: EventData)
  fun onDominantSpeakerEntry(data: EventData)
  fun onLegacySwitchEntry(data: EventData)
  fun onMediaPermissionEntry(data: EventData)
  fun onNetworkQualityTestBeginEntry(data: EventData)
  fun onNetworkQualityTestEndEntry(data: EventData)
  fun onParticipantRoleToggleEntry(data: EventData)
  fun onReceivingConsumerAudioStatus(status: String, id: Any)
  fun onReceivingConsumerVideoStatus(status: String, id: Any)
  fun onPingStatsEntry(data: EventData)
  fun onPreCallTestBeginEntry(data: EventData)
  fun onPreCallTestCompleteEntry(data: EventData)
  fun onReconnectAttemptEntry(data: EventData)
  fun onScreenShareRequestedEntry(data: EventData)
  fun onScreenShareStartedEntry(data: EventData)
  fun onScreenShareStoppedEntry(data: EventData)
  fun onTransportConnectedEntry(data: EventData)
  fun onVideoOffEntry(data: EventData)
  fun onVideoOnEntry(data: EventData)
  fun onVideoPlaybackFailureEntry(data: EventData)
  fun onVideoTrackFailureEntry(data: EventData)
  fun onWebSocketConnectedEntry(data: EventData)
}
