package io.dyte.callstats.media

import io.dyte.media.Producer
import io.dyte.media.hive.HiveProducer

class ProducerFacade(
  private val isHive: Boolean,
  private val mediasoupProducer: Producer? = null,
  private val hiveProducer: HiveProducer? = null
) {
  fun getId(): String {
    return if (isHive) hiveProducer!!.getId()
    else mediasoupProducer!!.id
  }

  fun getSsrc(): Long? {
    return if (isHive) hiveProducer!!.getSsrc()
    else mediasoupProducer!!.rtpParameters.encodings?.first()?.ssrc
  }
}