package io.dyte.callstats.observers

interface TestObserver {
  fun onDone(data: Any)
  fun onFailure(reason: String, lastUpdatedResults: Any?)
  fun onError(ex: Exception)
}

class InternalTestObserver(
  private val onDoneCb: (Any) -> Unit,
  private val onFailureCb: (String, Any?) -> Unit,
  private val onErrorCb: (Exception) -> Unit
) : TestObserver {
  override fun onDone(data: Any) {
    this.onDoneCb(data)
  }

  override fun onFailure(reason: String, lastUpdatedResults: Any?) {
    this.onFailureCb(reason, lastUpdatedResults)
  }

  override fun onError(ex: Exception) {
    this.onErrorCb(ex)
  }
}
