/*
 * Decompiled with CFR 0.152.
 */
package io.dvlopt.linux.i2c;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import io.dvlopt.linux.Linux;
import io.dvlopt.linux.SizeT;
import io.dvlopt.linux.i2c.I2CBuffer;
import io.dvlopt.linux.i2c.I2CFunctionalities;
import io.dvlopt.linux.i2c.I2CTransaction;
import io.dvlopt.linux.i2c.SMBus;
import io.dvlopt.linux.io.LinuxIO;
import java.io.FileNotFoundException;
import java.io.IOException;

public class I2CBus
implements AutoCloseable {
    private static final NativeLong I2C_RETRIES = new NativeLong(1793L, true);
    private static final NativeLong I2C_TIMEOUT = new NativeLong(1794L, true);
    private static final NativeLong I2C_SLAVE = new NativeLong(1795L, true);
    private static final NativeLong I2C_SLAVE_FORCE = new NativeLong(1798L, true);
    private static final NativeLong I2C_TENBIT = new NativeLong(1796L, true);
    private static final NativeLong I2C_FUNCS = new NativeLong(1797L, true);
    private static final NativeLong I2C_RDWR = new NativeLong(1799L, true);
    final int fd;
    private boolean isTenBit = false;
    private boolean isClosed = false;
    public final SMBus smbus = new SMBus(this);

    public I2CBus(int busNumber) throws IOException {
        this("/dev/i2c-" + busNumber);
    }

    public I2CBus(String path) throws IOException {
        this.fd = LinuxIO.open64((String)path, (int)2);
        if (this.fd < 0) {
            int errno = Linux.getErrno();
            switch (errno) {
                case 13: {
                    throw new FileNotFoundException("I2C Bus not found : " + path);
                }
                case 2: {
                    throw new FileNotFoundException("Permission denied : " + path);
                }
            }
            throw new IOException("Native error while opening I2C bus : errno " + errno);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed && LinuxIO.close((int)this.fd) != 0) {
            throw new IOException("Native error while closing I2C bus : errno " + Linux.getErrno());
        }
        this.isClosed = true;
    }

    void guardClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Unable to perform IO on closed I2C bus");
        }
    }

    static int getErrno() throws IOException {
        int errno = Linux.getErrno();
        switch (errno) {
            case 25: {
                throw new IOException("Unable to use inappropriate I2C bus");
            }
            case 121: {
                throw new IOException("Remote IO error during I2C operation");
            }
        }
        return errno;
    }

    public void doTransaction(I2CTransaction transaction) throws IOException {
        this.guardClosed();
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_RDWR, (Pointer)transaction.memory) < 0) {
            throw new IOException("Native error while doing an I2C transaction : errno " + I2CBus.getErrno());
        }
    }

    public I2CFunctionalities getFunctionalities() throws IOException {
        this.guardClosed();
        LongByReference longRef = new LongByReference();
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_FUNCS, (Pointer)longRef.getPointer()) < 0) {
            throw new IOException("Native error while getting the funcitonalities of an I2C bus : errno " + I2CBus.getErrno());
        }
        return new I2CFunctionalities((int)longRef.getValue());
    }

    public void selectSlave(int address) throws IOException {
        this.selectSlave(address, false, false);
    }

    public void selectSlave(int address, boolean force, boolean isTenBit) throws IOException {
        this.guardClosed();
        if (isTenBit) {
            if (!this.isTenBit) {
                if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_TENBIT, (int)1) < 0) {
                    throw new IOException("Native error while switching to 10 bit I2C addressing scheme : errno " + I2CBus.getErrno());
                }
                this.isTenBit = true;
            }
        } else if (this.isTenBit) {
            if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_TENBIT, (int)0) < 0) {
                throw new IOException("Native error while switching to 7 bit I2C addressing scheme : errno " + I2CBus.getErrno());
            }
            this.isTenBit = false;
        }
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)(force ? I2C_SLAVE_FORCE : I2C_SLAVE), (long)((long)address & 0xFFFFFFFFL)) < 0) {
            throw new IOException("Native error while selecting I2C slave " + address + " : errno " + I2CBus.getErrno());
        }
    }

    public void setRetries(int nRetries) throws IOException {
        this.guardClosed();
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_RETRIES, (long)((long)nRetries & 0xFFFFFFFFL)) < 0) {
            throw new IOException("Native error while setting I2C retries : errno " + I2CBus.getErrno());
        }
    }

    public void setTimeout(int milliseconds) throws IOException {
        this.guardClosed();
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_TIMEOUT, (long)((long)(milliseconds / 10) & 0xFFFFFFL)) < 0) {
            throw new IOException("Native error while setting I2C timeout : errno " + I2CBus.getErrno());
        }
    }

    public void read(I2CBuffer buffer) throws IOException {
        this.read(buffer, buffer.length);
    }

    public void read(I2CBuffer buffer, int length) throws IOException {
        this.guardClosed();
        if (LinuxIO.read((int)this.fd, (Pointer)buffer.memory, (SizeT)new SizeT((long)length)).intValue() < 0) {
            throw new IOException("Native error while writing I2C buffer : errno " + I2CBus.getErrno());
        }
    }

    public void write(I2CBuffer buffer) throws IOException {
        this.write(buffer, buffer.length);
    }

    public void write(I2CBuffer buffer, int length) throws IOException {
        this.guardClosed();
        if (LinuxIO.write((int)this.fd, (Pointer)buffer.memory, (SizeT)new SizeT((long)length)).intValue() < 0) {
            throw new IOException("Native error while writing I2C buffer : errno " + I2CBus.getErrno());
        }
    }
}

