/*
 * Decompiled with CFR 0.152.
 */
package io.dvlopt.linux.i2c;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import io.dvlopt.linux.LinuxException;
import io.dvlopt.linux.NativeMemory;
import io.dvlopt.linux.SizeT;
import io.dvlopt.linux.i2c.I2CBlock;
import io.dvlopt.linux.i2c.I2CBuffer;
import io.dvlopt.linux.i2c.I2CFunctionalities;
import io.dvlopt.linux.i2c.I2CTransaction;
import io.dvlopt.linux.i2c.internal.NativeI2CSmbusIoctlData;
import io.dvlopt.linux.io.LinuxIO;

public class I2CBus
implements AutoCloseable {
    private static final NativeLong I2C_RETRIES = new NativeLong(1793L, true);
    private static final NativeLong I2C_TIMEOUT = new NativeLong(1794L, true);
    private static final NativeLong I2C_SLAVE = new NativeLong(1795L, true);
    private static final NativeLong I2C_SLAVE_FORCE = new NativeLong(1798L, true);
    private static final NativeLong I2C_TENBIT = new NativeLong(1796L, true);
    private static final NativeLong I2C_FUNCS = new NativeLong(1797L, true);
    private static final NativeLong I2C_RDWR = new NativeLong(1799L, true);
    private static final NativeLong I2C_PEC = new NativeLong(1800L, true);
    private static final NativeLong I2C_SMBUS = new NativeLong(1824L, true);
    private static final byte I2C_SMBUS_READ = 1;
    private static final byte I2C_SMBUS_WRITE = 0;
    private static final byte I2C_SMBUS_QUICK = 0;
    private static final byte I2C_SMBUS_BYTE = 1;
    private static final byte I2C_SMBUS_BYTE_DATA = 2;
    private static final byte I2C_SMBUS_WORD_DATA = 3;
    private static final byte I2C_SMBUS_PROC_CALL = 4;
    private static final byte I2C_SMBUS_BLOCK_DATA = 5;
    private static final byte I2C_SMBUS_I2C_BLOCK_BROKEN = 6;
    private static final byte I2C_SMBUS_BLOCK_PROC_CALL = 7;
    private static final byte I2C_SMBUS_I2C_BLOCK_DATA = 8;
    private final int fd;
    private final Memory i2cSmbusIoctlData;
    private final Memory i2cSmbusData;
    private boolean isTenBit = false;

    public I2CBus(int busNumber) throws LinuxException {
        this("/dev/i2c-" + busNumber);
    }

    public I2CBus(String path) throws LinuxException {
        this.fd = LinuxIO.open64((String)path, (int)2);
        if (this.fd < 0) {
            throw new LinuxException("Unable to open an I2C bus at the given path");
        }
        this.i2cSmbusIoctlData = new Memory((long)NativeI2CSmbusIoctlData.SIZE);
        this.i2cSmbusData = new Memory(34L);
        this.i2cSmbusIoctlData.clear();
        this.i2cSmbusData.clear();
    }

    @Override
    public void close() throws LinuxException {
        if (LinuxIO.close((int)this.fd) != 0) {
            throw new LinuxException("Unable to close this I2C bus");
        }
    }

    public void doTransaction(I2CTransaction transaction) throws LinuxException {
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_RDWR, (Pointer)transaction.memory) < 0) {
            throw new LinuxException("Unable to fully perform requested I2C transaction");
        }
    }

    public I2CFunctionalities getFunctionalities() throws LinuxException {
        LongByReference longRef = new LongByReference();
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_FUNCS, (Pointer)longRef.getPointer()) < 0) {
            throw new LinuxException("Unable to get the I2C functionalities of this bus");
        }
        return new I2CFunctionalities((int)longRef.getValue());
    }

    public void selectSlave(int address) throws LinuxException {
        this.selectSlave(address, false, false);
    }

    public void selectSlave(int address, boolean force, boolean isTenBit) throws LinuxException {
        if (isTenBit) {
            if (!this.isTenBit) {
                if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_TENBIT, (int)1) < 0) {
                    throw new LinuxException("Unable to set 10 bit addressing");
                }
                this.isTenBit = true;
            }
        } else if (this.isTenBit) {
            if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_TENBIT, (int)0) < 0) {
                throw new LinuxException("Unable to set 7 bit addressing");
            }
            this.isTenBit = false;
        }
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)(force ? I2C_SLAVE_FORCE : I2C_SLAVE), (long)((long)address & 0xFFFFFFFFL)) < 0) {
            throw new LinuxException("Unable to use the given slave address");
        }
    }

    public void setRetries(int nRetries) throws LinuxException {
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_RETRIES, (long)((long)nRetries & 0xFFFFFFFFL)) < 0) {
            throw new LinuxException("Unable to set the number of retries");
        }
    }

    public void setTimeout(int milliseconds) throws LinuxException {
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_TIMEOUT, (long)((long)(milliseconds / 10) & 0xFFFFFFL)) < 0) {
            throw new LinuxException("Unable to set timeout");
        }
    }

    public void usePEC(boolean usePEC) throws LinuxException {
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_PEC, (long)(usePEC ? 1L : 0L)) < 0) {
            throw new LinuxException("Unable to set or unset PEC for SMBUS operations");
        }
    }

    private int i2cSmbusAccess(byte readWrite, int command, int size, Pointer data) throws LinuxException {
        this.i2cSmbusIoctlData.setByte((long)NativeI2CSmbusIoctlData.OFFSET_READ_WRITE, readWrite);
        this.i2cSmbusIoctlData.setByte((long)NativeI2CSmbusIoctlData.OFFSET_COMMAND, (byte)command);
        this.i2cSmbusIoctlData.setInt((long)NativeI2CSmbusIoctlData.OFFSET_SIZE, size);
        this.i2cSmbusIoctlData.setPointer((long)NativeI2CSmbusIoctlData.OFFSET_DATA, data);
        int result = LinuxIO.ioctl((int)this.fd, (NativeLong)I2C_SMBUS, (Pointer)this.i2cSmbusIoctlData);
        if (result < 0) {
            throw new LinuxException("Unable to perform I2C/SMBUS operation");
        }
        return result;
    }

    public void quick(boolean isWrite) throws LinuxException {
        this.i2cSmbusAccess(isWrite ? (byte)0 : 1, 0, 0, null);
    }

    public int readByteDirectly() throws LinuxException {
        this.i2cSmbusAccess((byte)1, 0, 1, (Pointer)this.i2cSmbusData);
        return NativeMemory.getUnsignedByte((Pointer)this.i2cSmbusData, (long)0L);
    }

    public int readByte(int command) throws LinuxException {
        this.i2cSmbusAccess((byte)1, command, 2, (Pointer)this.i2cSmbusData);
        return NativeMemory.getUnsignedByte((Pointer)this.i2cSmbusData, (long)0L);
    }

    public int readWord(int command) throws LinuxException {
        this.i2cSmbusAccess((byte)1, command, 3, (Pointer)this.i2cSmbusData);
        return NativeMemory.getUnsignedShort((Pointer)this.i2cSmbusData, (long)0L);
    }

    public int readBlock(int command, I2CBlock block) throws LinuxException {
        this.i2cSmbusAccess((byte)1, command, 5, (Pointer)block.memory);
        return block.readLength();
    }

    public void readI2CBlock(int command, I2CBlock block, int length) throws LinuxException {
        if (length > 32) {
            throw new IllegalArgumentException("Too many bytes requested.");
        }
        block.writeLength(length);
        this.i2cSmbusAccess((byte)1, command, length == 32 ? 6 : 8, (Pointer)block.memory);
        block.readLength();
    }

    public void read(I2CBuffer buffer) throws LinuxException {
        this.read(buffer, buffer.length);
    }

    public void read(I2CBuffer buffer, int length) throws LinuxException {
        if (LinuxIO.read((int)this.fd, (Pointer)buffer.memory, (SizeT)new SizeT((long)length)).intValue() < 0) {
            throw new LinuxException("Unable to read to I2C buffer");
        }
    }

    public void writeByteDirectly(int b) throws LinuxException {
        this.i2cSmbusAccess((byte)0, b, 1, null);
    }

    public void writeByte(int command, int b) throws LinuxException {
        NativeMemory.setUnsignedByte((Pointer)this.i2cSmbusData, (long)0L, (int)b);
        this.i2cSmbusAccess((byte)0, command, 2, (Pointer)this.i2cSmbusData);
    }

    public void writeWord(int command, int word) throws LinuxException {
        NativeMemory.setUnsignedShort((Pointer)this.i2cSmbusData, (long)0L, (int)word);
        this.i2cSmbusAccess((byte)0, command, 3, (Pointer)this.i2cSmbusData);
    }

    public void writeBlock(int command, I2CBlock block) throws LinuxException {
        block.writeLength();
        this.i2cSmbusAccess((byte)0, command, 8, (Pointer)block.memory);
    }

    public void writeI2CBlock(int command, I2CBlock block) throws LinuxException {
        block.writeLength();
        this.i2cSmbusAccess((byte)0, command, 6, (Pointer)block.memory);
    }

    public void write(I2CBuffer buffer) throws LinuxException {
        this.write(buffer, buffer.length);
    }

    public void write(I2CBuffer buffer, int length) throws LinuxException {
        if (LinuxIO.write((int)this.fd, (Pointer)buffer.memory, (SizeT)new SizeT((long)length)).intValue() < 0) {
            throw new LinuxException("Unable to write I2C buffer");
        }
    }

    public int processCall(int command, int word) throws LinuxException {
        NativeMemory.setUnsignedShort((Pointer)this.i2cSmbusData, (long)0L, (int)word);
        this.i2cSmbusAccess((byte)0, command, 4, (Pointer)this.i2cSmbusData);
        return NativeMemory.getUnsignedShort((Pointer)this.i2cSmbusData, (long)0L);
    }

    public int blockProcessCall(int command, I2CBlock block) throws LinuxException {
        return this.blockProcessCall(command, block, block);
    }

    public int blockProcessCall(int command, I2CBlock blockWrite, I2CBlock blockRead) throws LinuxException {
        I2CBlock block;
        blockWrite.writeLength();
        if (blockWrite == blockRead) {
            block = blockWrite;
        } else {
            NativeMemory.copy((Memory)blockWrite.memory, (Pointer)blockRead.memory);
            block = blockRead;
        }
        this.i2cSmbusAccess((byte)0, command, 7, (Pointer)block.memory);
        return block.readLength();
    }
}

