/*
 * Decompiled with CFR 0.152.
 */
package io.dvlopt.linux.i2c;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import io.dvlopt.linux.NativeMemory;

public class I2CBlock {
    public static final int SIZE = 32;
    private int length;
    final Memory memory = new Memory(35L);

    public I2CBlock() {
        this.memory.clear();
    }

    public I2CBlock clear() {
        this.memory.clear();
        this.length = 0;
        return this;
    }

    public int length() {
        return this.length;
    }

    int readLength() {
        this.length = NativeMemory.getUnsignedByte((Pointer)this.memory, (long)0L);
        return this.length;
    }

    void writeLength() {
        this.writeLength(this.length);
    }

    void writeLength(int length) {
        NativeMemory.setUnsignedByte((Pointer)this.memory, (long)0L, (int)length);
        this.length = length;
    }

    public int get(int index) {
        return NativeMemory.getUnsignedByte((Pointer)this.memory, (long)(index + 1));
    }

    public I2CBlock set(int index, int b) {
        NativeMemory.setUnsignedByte((Pointer)this.memory, (long)(++index), (int)b);
        this.length = Math.max(this.length, index);
        return this;
    }
}

