/*
 * Decompiled with CFR 0.152.
 */
package io.dvlopt.linux.gpio;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import io.dvlopt.linux.gpio.GpioFlags;
import io.dvlopt.linux.gpio.GpioUtils;
import io.dvlopt.linux.gpio.internal.NativeGpioLineInfo;

public class GpioLineInfo {
    final Memory memory = new Memory((long)NativeGpioLineInfo.SIZE);

    public GpioLineInfo() {
        this.memory.clear();
    }

    public String getConsumer() {
        return GpioUtils.getString((Pointer)this.memory, NativeGpioLineInfo.OFFSET_CONSUMER);
    }

    public int getLine() {
        return this.memory.getInt((long)NativeGpioLineInfo.OFFSET_LINE);
    }

    void setLine(int line) {
        this.memory.setInt((long)NativeGpioLineInfo.OFFSET_LINE, line);
    }

    public String getName() {
        return GpioUtils.getString((Pointer)this.memory, NativeGpioLineInfo.OFFSET_NAME);
    }

    private int getRawFlags() {
        return this.memory.getInt((long)NativeGpioLineInfo.OFFSET_FLAGS);
    }

    public GpioFlags getFlags() {
        return new GpioFlags().fromLineInfo(this.getRawFlags());
    }

    public boolean isUsed() {
        return GpioUtils.isSet(this.getRawFlags(), 1);
    }
}

