/*
 * Decompiled with CFR 0.152.
 */
package io.dvlopt.linux.gpio;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import io.dvlopt.linux.gpio.GpioFlags;
import io.dvlopt.linux.gpio.GpioLine;
import io.dvlopt.linux.gpio.GpioUtils;
import io.dvlopt.linux.gpio.internal.NativeGpioHandleRequest;

public class GpioHandleRequest {
    final Memory memory = new Memory((long)NativeGpioHandleRequest.SIZE);

    public GpioHandleRequest() {
        this.memory.clear();
    }

    private GpioHandleRequest setRawFlags(int flags) {
        this.memory.setInt((long)NativeGpioHandleRequest.OFFSET_FLAGS, flags);
        return this;
    }

    public GpioHandleRequest setFlags(GpioFlags flags) {
        return this.setRawFlags(flags.forRequest());
    }

    public GpioHandleRequest unsetFlags() {
        return this.setRawFlags(0);
    }

    public GpioFlags getFlags() {
        return new GpioFlags().fromRequest(this.memory.getInt((long)NativeGpioHandleRequest.OFFSET_FLAGS));
    }

    public String getConsumer() {
        return GpioUtils.getString((Pointer)this.memory, NativeGpioHandleRequest.OFFSET_CONSUMER);
    }

    public GpioHandleRequest setConsumer(String consumer) {
        GpioUtils.setConsumer((Pointer)this.memory, NativeGpioHandleRequest.OFFSET_CONSUMER, consumer);
        return this;
    }

    int getFD() {
        return this.memory.getInt((long)NativeGpioHandleRequest.OFFSET_FD);
    }

    public GpioLine addLine(int lineNumber) {
        int index = this.memory.getInt((long)NativeGpioHandleRequest.OFFSET_LINES);
        this.memory.setInt((long)(NativeGpioHandleRequest.OFFSET_LINE_OFFSETS + 4 * index), lineNumber);
        this.memory.setInt((long)NativeGpioHandleRequest.OFFSET_LINES, index + 1);
        return new GpioLine(lineNumber, index);
    }

    public GpioLine addLine(int lineNumber, boolean value) {
        GpioLine gpioLine = this.addLine(lineNumber);
        this.memory.setByte((long)(NativeGpioHandleRequest.OFFSET_DEFAULT_VALUES + gpioLine.index), (byte)(value ? 1 : 0));
        return gpioLine;
    }
}

