/*
 * Decompiled with CFR 0.152.
 */
package io.dvlopt.linux.gpio;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import io.dvlopt.linux.LinuxException;
import io.dvlopt.linux.gpio.GpioBuffer;
import io.dvlopt.linux.io.LinuxIO;

public class GpioHandle
implements AutoCloseable {
    static final NativeLong GPIOHANDLE_GET_LINE_VALUES_IOCTL = new NativeLong(3225465864L, true);
    static final NativeLong GPIOHANDLE_SET_LINE_VALUES_IOCTL = new NativeLong(3225465865L, true);
    final int fd;
    private boolean isClosed = false;

    GpioHandle(int fd) {
        this.fd = fd;
    }

    public void read(GpioBuffer buffer) throws LinuxException {
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)GPIOHANDLE_GET_LINE_VALUES_IOCTL, (Pointer)buffer.getPointer()) < 0) {
            throw new LinuxException("Unable to read values for the given GPIO handle");
        }
    }

    public void write(GpioBuffer buffer) throws LinuxException {
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)GPIOHANDLE_SET_LINE_VALUES_IOCTL, (Pointer)buffer.getPointer()) < 0) {
            throw new LinuxException("Unable to write values for the given GPIO handle");
        }
    }

    @Override
    public void close() throws LinuxException {
        if (!this.isClosed) {
            if (LinuxIO.close((int)this.fd) != 0) {
                throw new LinuxException("Unable to close this GPIO handle");
            }
            this.isClosed = true;
        }
    }
}

