/*
 * Decompiled with CFR 0.152.
 */
package io.dvlopt.linux.gpio;

import io.dvlopt.linux.gpio.GpioUtils;

public class GpioFlags {
    private boolean isOutput = false;
    private boolean isActiveLow = false;
    private boolean isOpenDrain = false;
    private boolean isOpenSource = false;

    public GpioFlags setInput() {
        this.isOutput = false;
        return this;
    }

    public GpioFlags setOutput() {
        this.isOutput = true;
        return this;
    }

    public GpioFlags setActiveLow(boolean isActiveLow) {
        this.isActiveLow = isActiveLow;
        return this;
    }

    public GpioFlags setOpenDrain(boolean isOpenDrain) {
        this.isOpenDrain = isOpenDrain;
        return this;
    }

    public GpioFlags setOpenSource(boolean isOpenSource) {
        this.isOpenSource = isOpenSource;
        return this;
    }

    public boolean isInput() {
        return !this.isOutput;
    }

    public boolean isOutput() {
        return this.isOutput;
    }

    public boolean isActiveLow() {
        return this.isActiveLow;
    }

    public boolean isOpenDrain() {
        return this.isOpenDrain;
    }

    public boolean isOpenSource() {
        return this.isOpenSource;
    }

    int forRequest() {
        int flags = 0;
        flags |= this.isOutput ? 2 : 1;
        if (this.isActiveLow) {
            flags |= 4;
        }
        if (this.isOpenDrain) {
            flags |= 8;
        }
        if (this.isOpenSource) {
            flags |= 0x10;
        }
        return flags;
    }

    GpioFlags fromRequest(int flags) {
        this.isOutput = GpioUtils.isSet(flags, 2);
        this.isActiveLow = GpioUtils.isSet(flags, 4);
        this.isOpenDrain = GpioUtils.isSet(flags, 8);
        this.isOpenSource = GpioUtils.isSet(flags, 16);
        return this;
    }

    GpioFlags fromLineInfo(int flags) {
        this.isOutput = GpioUtils.isSet(flags, 2);
        this.isActiveLow = GpioUtils.isSet(flags, 4);
        this.isOpenDrain = GpioUtils.isSet(flags, 8);
        this.isOpenSource = GpioUtils.isSet(flags, 16);
        return this;
    }

    public boolean equals(GpioFlags flags) {
        return this.isOutput == flags.isOutput && this.isActiveLow == flags.isActiveLow && this.isOpenDrain == flags.isOpenDrain && this.isOpenSource == flags.isOpenSource;
    }

    public boolean equals(Object o) {
        return o instanceof GpioFlags ? this.equals((GpioFlags)o) : false;
    }

    static class LineInfoFlags {
        static final int KERNEL = 1;
        static final int IS_OUT = 2;
        static final int ACTIVE_LOW = 4;
        static final int OPEN_DRAIN = 8;
        static final int OPEN_SOURCE = 16;

        LineInfoFlags() {
        }
    }

    private static class RequestFlags {
        private static final int INPUT = 1;
        private static final int OUTPUT = 2;
        private static final int ACTIVE_LOW = 4;
        private static final int OPEN_DRAIN = 8;
        private static final int OPEN_SOURCE = 16;

        private RequestFlags() {
        }
    }
}

