/*
 * Decompiled with CFR 0.152.
 */
package io.dvlopt.linux.gpio;

import io.dvlopt.linux.LinuxException;
import io.dvlopt.linux.epoll.Epoll;
import io.dvlopt.linux.epoll.EpollEvent;
import io.dvlopt.linux.epoll.EpollEventFlag;
import io.dvlopt.linux.epoll.EpollEventFlags;
import io.dvlopt.linux.gpio.GpioEvent;
import io.dvlopt.linux.gpio.GpioEventHandle;

public class GpioEventWatcher
implements AutoCloseable {
    private Epoll epoll = new Epoll();
    private EpollEvent epollEvent = new EpollEvent();
    private static final EpollEventFlags eventFlags = new EpollEventFlags();

    public GpioEventWatcher addHandle(GpioEventHandle handle, int id) throws LinuxException {
        EpollEvent epollEvent = new EpollEvent();
        epollEvent.setEventFlags(eventFlags).setUserData((long)handle.fd | ((long)id & 0xFFFFFFFFL) << 32);
        this.epoll.add(handle.fd, epollEvent);
        return this;
    }

    public GpioEventWatcher removeHandle(GpioEventHandle handle) throws LinuxException {
        this.epoll.remove(handle.fd);
        return this;
    }

    public boolean waitForEvent(GpioEvent data) throws LinuxException {
        return this.waitForEvent(data, -1);
    }

    public boolean waitForEvent(GpioEvent data, int timeout) throws LinuxException {
        if (this.epoll.wait(this.epollEvent, timeout) > 0) {
            long longValue = this.epollEvent.getUserData();
            int fd = (int)longValue;
            int id = (int)(longValue >>> 32);
            data.read(fd, id);
            return true;
        }
        return false;
    }

    @Override
    public void close() throws LinuxException {
        this.epoll.close();
    }

    static {
        eventFlags.set(EpollEventFlag.EPOLLIN).set(EpollEventFlag.EPOLLPRI);
    }
}

