/*
 * Decompiled with CFR 0.152.
 */
package io.dvlopt.linux.gpio;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import io.dvlopt.linux.gpio.GpioEdgeDetection;
import io.dvlopt.linux.gpio.GpioFlags;
import io.dvlopt.linux.gpio.GpioUtils;
import io.dvlopt.linux.gpio.internal.NativeGpioEventRequest;

public class GpioEventRequest {
    private static final int DEFAULT_FLAGS = new GpioFlags().setInput().forRequest();
    final Memory memory = new Memory((long)NativeGpioEventRequest.SIZE);
    private GpioEdgeDetection edgeDetection;

    public GpioEventRequest(int line) {
        this(line, GpioEdgeDetection.RISING_AND_FALLING, DEFAULT_FLAGS);
    }

    public GpioEventRequest(int line, GpioEdgeDetection edgeDetection) {
        this(line, edgeDetection, DEFAULT_FLAGS);
    }

    public GpioEventRequest(int line, GpioEdgeDetection edgeDetection, GpioFlags flags) {
        this(line, edgeDetection, flags.forRequest());
    }

    private GpioEventRequest(int line, GpioEdgeDetection edgeDetection, int flags) {
        this.memory.clear();
        this.setLine(line);
        this.setEdgeDetection(edgeDetection);
        this.setRawFlags(flags);
    }

    private GpioEventRequest setRawFlags(int flags) {
        this.memory.setInt((long)NativeGpioEventRequest.OFFSET_HANDLE_FLAGS, flags);
        return this;
    }

    public GpioEventRequest setFlags(GpioFlags flags) {
        return this.setRawFlags(flags.forRequest());
    }

    public GpioEventRequest unsetFlags() {
        return this.setRawFlags(0);
    }

    public GpioFlags getFlags() {
        return new GpioFlags().fromRequest(this.memory.getInt((long)NativeGpioEventRequest.OFFSET_HANDLE_FLAGS));
    }

    public GpioEdgeDetection getEdgeDetection() {
        return this.edgeDetection;
    }

    public GpioEventRequest setEdgeDetection(GpioEdgeDetection edgeDetection) {
        this.memory.setInt((long)NativeGpioEventRequest.OFFSET_EVENT_FLAGS, edgeDetection.flags);
        this.edgeDetection = edgeDetection;
        return this;
    }

    int getFD() {
        return this.memory.getInt((long)NativeGpioEventRequest.OFFSET_FD);
    }

    public int getLine() {
        return this.memory.getInt((long)NativeGpioEventRequest.OFFSET_LINE);
    }

    public GpioEventRequest setLine(int line) {
        this.memory.setInt((long)NativeGpioEventRequest.OFFSET_LINE, line);
        return this;
    }

    public String getConsumer() {
        return GpioUtils.getString((Pointer)this.memory, NativeGpioEventRequest.OFFSET_CONSUMER);
    }

    public GpioEventRequest setConsumer(String consumer) {
        GpioUtils.setConsumer((Pointer)this.memory, NativeGpioEventRequest.OFFSET_CONSUMER, consumer);
        return this;
    }
}

