/*
 * Decompiled with CFR 0.152.
 */
package io.dvlopt.linux.gpio;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import io.dvlopt.linux.LinuxException;
import io.dvlopt.linux.gpio.GpioBuffer;
import io.dvlopt.linux.gpio.GpioEvent;
import io.dvlopt.linux.gpio.GpioHandle;
import io.dvlopt.linux.gpio.GpioLine;
import io.dvlopt.linux.io.LinuxIO;

public class GpioEventHandle
implements AutoCloseable {
    final int fd;
    private final GpioLine line;
    private boolean isClosed = false;

    GpioEventHandle(int fd, int line) {
        this.fd = fd;
        this.line = new GpioLine(line, 0);
    }

    public GpioLine getLine() {
        return this.line;
    }

    public void read(GpioBuffer buffer) throws LinuxException {
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)GpioHandle.GPIOHANDLE_GET_LINE_VALUES_IOCTL, (Pointer)buffer.getPointer()) < 0) {
            throw new LinuxException("Unable to read the line using the given GPIO event handle");
        }
    }

    public GpioEvent waitForEvent() throws LinuxException {
        return this.waitForEvent(new GpioEvent());
    }

    public GpioEvent waitForEvent(GpioEvent data) throws LinuxException {
        data.read(this.fd, this.line.lineNumber);
        return data;
    }

    @Override
    public void close() throws LinuxException {
        if (!this.isClosed) {
            if (LinuxIO.close((int)this.fd) != 0) {
                throw new LinuxException("Unable to close this GPIO event handle");
            }
            this.isClosed = true;
        }
    }
}

