/*
 * Decompiled with CFR 0.152.
 */
package io.dvlopt.linux.gpio;

import com.sun.jna.Pointer;
import io.dvlopt.linux.LinuxException;
import io.dvlopt.linux.SizeT;
import io.dvlopt.linux.gpio.internal.NativeGpioEventData;
import io.dvlopt.linux.io.LinuxIO;

public class GpioEvent {
    private static final int GPIO_EVENT_RISING_EDGE = 1;
    private static final int GPIO_EVENT_FALLING_EDGE = 2;
    final NativeGpioEventData nativeStruct = new NativeGpioEventData();
    int id = 0;

    void read(int fd) throws LinuxException {
        this.read(fd, 0);
    }

    void read(int fd, int id) throws LinuxException {
        if (LinuxIO.read((int)fd, (Pointer)this.nativeStruct.getPointer(), (SizeT)NativeGpioEventData.SIZE).intValue() < 0) {
            throw new LinuxException("Unable to read GPIO event");
        }
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public long getNanoTimestamp() {
        return this.nativeStruct.readTimestamp();
    }

    public boolean isRising() {
        return (this.nativeStruct.readId() & 1) > 0;
    }

    public boolean isFalling() {
        return (this.nativeStruct.readId() & 2) > 0;
    }
}

