/*
 * Decompiled with CFR 0.152.
 */
package io.dvlopt.linux.gpio;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import io.dvlopt.linux.LinuxException;
import io.dvlopt.linux.gpio.GpioChipInfo;
import io.dvlopt.linux.gpio.GpioEventHandle;
import io.dvlopt.linux.gpio.GpioEventRequest;
import io.dvlopt.linux.gpio.GpioHandle;
import io.dvlopt.linux.gpio.GpioHandleRequest;
import io.dvlopt.linux.gpio.GpioLineInfo;
import io.dvlopt.linux.io.LinuxIO;

public class GpioDevice
implements AutoCloseable {
    private static final NativeLong GPIO_GET_CHIPINFO_IOCTL = new NativeLong(2151986177L, true);
    private static final NativeLong GPIO_GET_LINEINFO_IOCTL = new NativeLong(3225990146L, true);
    private static final NativeLong GPIO_GET_LINEHANDLE_IOCTL = new NativeLong(3245126659L, true);
    private static final NativeLong GPIO_GET_LINEEVENT_IOCTL = new NativeLong(3224417284L, true);
    private int fd;
    private boolean isClosed = false;

    public GpioDevice(String path) throws LinuxException {
        int fd = LinuxIO.open64((String)path, (int)0);
        if (fd < 0) {
            throw new LinuxException("Unable to open GPIO device");
        }
        this.fd = fd;
    }

    public GpioDevice(int number) throws LinuxException {
        this("/dev/gpiochip" + number);
    }

    @Override
    public void close() throws LinuxException {
        if (!this.isClosed) {
            if (LinuxIO.close((int)this.fd) != 0) {
                throw new LinuxException("Unable to close GPIO device");
            }
            this.isClosed = true;
        }
    }

    public GpioChipInfo requestChipInfo() throws LinuxException {
        return this.requestChipInfo(new GpioChipInfo());
    }

    public GpioChipInfo requestChipInfo(GpioChipInfo info) throws LinuxException {
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)GPIO_GET_CHIPINFO_IOCTL, (Pointer)info.memory) < 0) {
            throw new LinuxException("Unable to retrieve informations about GPIO device");
        }
        return info;
    }

    public GpioLineInfo requestLineInfo(int line) throws LinuxException {
        return this.requestLineInfo(line, new GpioLineInfo());
    }

    public GpioLineInfo requestLineInfo(int line, GpioLineInfo info) throws LinuxException {
        System.out.println("Is out 1 : " + info.getFlags().isOutput());
        info.setLine(line);
        System.out.println("Is out 2 : " + info.getFlags().isOutput());
        Pointer ptr = new Pointer(Pointer.nativeValue((Pointer)info.memory));
        System.out.println("FLAGS = " + ptr.getInt(4L));
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)GPIO_GET_LINEINFO_IOCTL, (Pointer)info.memory) < 0) {
            throw new LinuxException("Unable to retrieve information about the request GPIO line");
        }
        Pointer ptr2 = new Pointer(Pointer.nativeValue((Pointer)info.memory));
        System.out.println("FLAGS = " + ptr2.getInt(4L));
        System.out.println("Is out 3 : " + info.getFlags().isOutput());
        return info;
    }

    public GpioHandle requestHandle(GpioHandleRequest request) throws LinuxException {
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)GPIO_GET_LINEHANDLE_IOCTL, (Pointer)request.memory) < 0) {
            throw new LinuxException("Unable to provide a GPIO handle");
        }
        return new GpioHandle(request.getFD());
    }

    public GpioEventHandle requestEvent(GpioEventRequest request) throws LinuxException {
        if (LinuxIO.ioctl((int)this.fd, (NativeLong)GPIO_GET_LINEEVENT_IOCTL, (Pointer)request.memory) < 0) {
            throw new LinuxException("Unable to provide a GPIO event handle");
        }
        return new GpioEventHandle(request.getFD(), request.getLine());
    }
}

