/*
 * Decompiled with CFR 0.152.
 */
package io.dstore.helper;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.dstore.elastic.item.Item;
import org.json.JSONObject;
import org.json.XML;

public class Converter {
    public static String toItemXml(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("item is null");
        }
        try {
            String jsonString = JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)item);
            JSONObject jsonObject = new JSONObject(jsonString.replaceAll("\"([0-9]+(-details)?)\":\\{\"name\":", "\"id_$1\":{\"name\":"));
            return "<item>" + XML.toString((Object)jsonObject) + "</item>";
        }
        catch (InvalidProtocolBufferException ex) {
            throw new IllegalArgumentException("unable to convert item with documentId " + item.getDocumentId(), ex);
        }
    }
}

