/*
 * Decompiled with CFR 0.152.
 */
package io.dstore.helper;

import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLException;

public class ChannelHelper {
    public static ManagedChannel getSslChannel(String host, int port) throws SSLException {
        return ChannelHelper.getSslChannel(host, port, null);
    }

    public static ManagedChannel getSslChannel(String host, int port, String caFile) throws SSLException {
        NettyChannelBuilder channelBuilder = host.matches("^(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$") ? NettyChannelBuilder.forAddress((String)host, (int)port) : NettyChannelBuilder.forTarget((String)("dns:///" + host + ":" + port));
        ChannelHelper.setSsl(channelBuilder, caFile);
        return channelBuilder.build();
    }

    private static NettyChannelBuilder setSsl(NettyChannelBuilder channelBuilder, String caFile) throws SSLException {
        channelBuilder.negotiationType(NegotiationType.TLS);
        if (caFile != null) {
            channelBuilder.sslContext(GrpcSslContexts.forClient().trustManager(ClassLoader.class.getResourceAsStream(caFile)).build());
        } else {
            channelBuilder.sslContext(GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build());
        }
        return channelBuilder;
    }
}

