/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.swagger.v3;

import io.domainlifecycles.reflect.JavaReflect;
import io.domainlifecycles.reflect.MemberSelect;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPITemporalTypeExtension {
    private static final Logger log = LoggerFactory.getLogger(OpenAPITemporalTypeExtension.class);
    private static final String REF_PREFIX = "#/components/schemas/";

    public static void extendOpenAPISchemaForTemporalTypes(OpenAPI openAPI) {
        if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() != null) {
            OpenAPITemporalTypeExtension.replaceLocalTimeSchema(openAPI);
            OpenAPITemporalTypeExtension.modifyTemporalSchemaReferences(openAPI);
        }
    }

    private static void replaceLocalTimeSchema(OpenAPI openAPI) {
        Schema localTimeSchema = (Schema)openAPI.getComponents().getSchemas().get(LocalTime.class.getName());
        if (localTimeSchema != null) {
            Schema newLocalTimeSchema = new Schema();
            newLocalTimeSchema.setName(localTimeSchema.getName());
            newLocalTimeSchema.setType("string");
            newLocalTimeSchema.setPattern("^([0-1][0-9]|[2][0-4])[:]([0-5][0-9])[:]([0-5][0-9])(\\.[0-9]{1,6})?$");
            openAPI.getComponents().getSchemas().put(LocalTime.class.getName(), newLocalTimeSchema);
        }
    }

    private static void modifyTemporalSchemaReferences(OpenAPI openAPI) {
        AtomicBoolean needToAddOffsetTimeSchema = new AtomicBoolean();
        needToAddOffsetTimeSchema.set(false);
        AtomicBoolean needToAddYearMonthSchema = new AtomicBoolean();
        needToAddYearMonthSchema.set(false);
        AtomicBoolean needToAddMonthDaySchema = new AtomicBoolean();
        needToAddMonthDaySchema.set(false);
        AtomicBoolean needToAddYearSchema = new AtomicBoolean();
        needToAddYearSchema.set(false);
        openAPI.getComponents().getSchemas().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("io.domainlifecycles.spring.http.ResponseObject")).forEach(entry -> {
            try {
                Class<?> type = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getKey());
                JavaReflect.fields(type, (MemberSelect)MemberSelect.HIERARCHY).stream().filter(f -> !Modifier.isStatic(f.getModifiers()) && (OpenAPITemporalTypeExtension.containsType(f, OffsetTime.class) || OpenAPITemporalTypeExtension.containsType(f, YearMonth.class) || OpenAPITemporalTypeExtension.containsType(f, MonthDay.class) || OpenAPITemporalTypeExtension.containsType(f, Year.class))).forEach(f -> {
                    if (OpenAPITemporalTypeExtension.containsType(f, OffsetTime.class)) {
                        needToAddOffsetTimeSchema.set(true);
                        OpenAPITemporalTypeExtension.modifyPropertySchemaReference((Schema)entry.getValue(), f.getName(), OffsetTime.class.getName());
                    } else if (OpenAPITemporalTypeExtension.containsType(f, YearMonth.class)) {
                        needToAddYearMonthSchema.set(true);
                        OpenAPITemporalTypeExtension.modifyPropertySchemaReference((Schema)entry.getValue(), f.getName(), YearMonth.class.getName());
                    } else if (OpenAPITemporalTypeExtension.containsType(f, MonthDay.class)) {
                        needToAddMonthDaySchema.set(true);
                        OpenAPITemporalTypeExtension.modifyPropertySchemaReference((Schema)entry.getValue(), f.getName(), MonthDay.class.getName());
                    } else if (OpenAPITemporalTypeExtension.containsType(f, Year.class)) {
                        needToAddYearSchema.set(true);
                        OpenAPITemporalTypeExtension.modifyPropertySchemaReference((Schema)entry.getValue(), f.getName(), Year.class.getName());
                    }
                });
            }
            catch (ClassNotFoundException e) {
                log.warn("Wasn't able to add/modify potential temporal schema information for '" + (String)entry.getKey() + "'!");
            }
        });
        if (needToAddOffsetTimeSchema.get()) {
            OpenAPITemporalTypeExtension.addOffsetTimeSchema(openAPI);
        }
        if (needToAddYearMonthSchema.get()) {
            OpenAPITemporalTypeExtension.addYearMonthSchema(openAPI);
        }
        if (needToAddMonthDaySchema.get()) {
            OpenAPITemporalTypeExtension.addMonthDaySchema(openAPI);
        }
        if (needToAddYearSchema.get()) {
            OpenAPITemporalTypeExtension.addYearSchema(openAPI);
        }
    }

    private static boolean containsType(Field f, Class<?> type) {
        if (Optional.class.isAssignableFrom(f.getType()) || Collection.class.isAssignableFrom(f.getType())) {
            return f.getGenericType().getTypeName().contains("<" + type.getName() + ">");
        }
        return type.isAssignableFrom(f.getType());
    }

    private static void addOffsetTimeSchema(OpenAPI openAPI) {
        if (openAPI.getComponents().getSchemas().get(OffsetTime.class.getName()) == null) {
            Schema offsetTimeSchema = new Schema();
            offsetTimeSchema.setType("string");
            offsetTimeSchema.setPattern("^([0-1][0-9]|[2][0-4])[:]([0-5][0-9])[:]([0-5][0-9])(\\.[0-9]{1,6})?([+]|[-])[0-9]{2,2}[:][0-9]{2,2}$");
            openAPI.getComponents().addSchemas(OffsetTime.class.getName(), offsetTimeSchema);
        }
    }

    private static void addYearMonthSchema(OpenAPI openAPI) {
        if (openAPI.getComponents().getSchemas().get(YearMonth.class.getName()) == null) {
            Schema yearMonthSchema = new Schema();
            yearMonthSchema.setType("string");
            yearMonthSchema.setPattern("^[0-9]{4,4}[-][0-1][0-9]$");
            openAPI.getComponents().addSchemas(YearMonth.class.getName(), yearMonthSchema);
        }
    }

    private static void addMonthDaySchema(OpenAPI openAPI) {
        if (openAPI.getComponents().getSchemas().get(MonthDay.class.getName()) == null) {
            Schema monthDaySchema = new Schema();
            monthDaySchema.setType("string");
            monthDaySchema.setPattern("^--[0-1][0-9]-[0-3][0-9]$");
            openAPI.getComponents().addSchemas(MonthDay.class.getName(), monthDaySchema);
        }
    }

    private static void addYearSchema(OpenAPI openAPI) {
        if (openAPI.getComponents().getSchemas().get(Year.class.getName()) == null) {
            Schema yearSchema = new Schema();
            yearSchema.setType("string");
            yearSchema.setPattern("^([+]|[-])?[0-9]{4,4}$");
            openAPI.getComponents().addSchemas(Year.class.getName(), yearSchema);
        }
    }

    private static void modifyPropertySchemaReference(Schema<?> typeSchema, String propertyName, String propertyTypeFullQualifiedName) {
        Schema propertySchema;
        if (typeSchema.getProperties() != null && (propertySchema = (Schema)typeSchema.getProperties().get(propertyName)) != null) {
            propertySchema.setType(null);
            propertySchema.setJsonSchema(null);
            propertySchema.setProperties(null);
            propertySchema.set$ref(REF_PREFIX + propertyTypeFullQualifiedName);
        }
    }
}

