/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.swagger.v3;

import io.domainlifecycles.reflect.JavaReflect;
import io.domainlifecycles.reflect.MemberSelect;
import io.domainlifecycles.swagger.v3.resource.ResourceBundle;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import jakarta.validation.Validation;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ContainerElementTypeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIPropertyBeanValidationExtension {
    private static final Logger log = LoggerFactory.getLogger(OpenAPIPropertyBeanValidationExtension.class);
    private static Validator validatorJavax;
    private static jakarta.validation.Validator validatorJakarta;
    private static final String BV_2_0_NOT_EMPTY = "javax.validation.constraints.NotEmpty";
    private static final String BV_3_0_NOT_EMPTY = "jakarta.validation.constraints.NotEmpty";
    private static final String BV_2_0_NOT_BLANK = "javax.validation.constraints.NotBlank";
    private static final String BV_3_0_NOT_BLANK = "jakarta.validation.constraints.NotBlank";
    private static final String BV_2_0_EMAIL = "javax.validation.constraints.Email";
    private static final String BV_3_0_EMAIL = "jakarta.validation.constraints.Email";
    private static final String BV_2_0_PATTERN = "javax.validation.constraints.Pattern";
    private static final String BV_3_0_PATTERN = "jakarta.validation.constraints.Pattern";
    private static final String BV_PATTERN_ATTRIBUTE_REGEXP = "regexp";
    private static final String BV_2_0_SIZE = "javax.validation.constraints.Size";
    private static final String BV_3_0_SIZE = "jakarta.validation.constraints.Size";
    private static final String BV_SIZE_ATTRIBUTE_MAX = "max";
    private static final String BV_SIZE_ATTRIBUTE_MIN = "min";
    private static final String BV_2_0_MIN = "javax.validation.constraints.Min";
    private static final String BV_3_0_MIN = "jakarta.validation.constraints.Min";
    private static final String BV_MIN_ATTRIBUTE_VALUE = "value";
    private static final String BV_2_0_MAX = "javax.validation.constraints.Max";
    private static final String BV_3_0_MAX = "jakarta.validation.constraints.Max";
    private static final String BV_MAX_ATTRIBUTE_VALUE = "value";
    private static final String BV_2_0_DECIMAL_MIN = "javax.validation.constraints.DecimalMin";
    private static final String BV_3_0_DECIMAL_MIN = "jakarta.validation.constraints.DecimalMin";
    private static final String BV_DECIMAL_MIN_ATTRIBUTE_VALUE = "value";
    private static final String BV_DECIMAL_MIN_ATTRIBUTE_INCLUSIVE = "inclusive";
    private static final String BV_2_0_DECIMAL_MAX = "javax.validation.constraints.DecimalMax";
    private static final String BV_3_0_DECIMAL_MAX = "jakarta.validation.constraints.DecimalMax";
    private static final String BV_DECIMAL_MAX_ATTRIBUTE_VALUE = "value";
    private static final String BV_DECIMAL_MAX_ATTRIBUTE_INCLUSIVE = "inclusive";
    private static final String BV_2_0_NEGATIVE = "javax.validation.constraints.Negative";
    private static final String BV_3_0_NEGATIVE = "jakarta.validation.constraints.Negative";
    private static final String BV_2_0_POSITIVE = "javax.validation.constraints.Positive";
    private static final String BV_3_0_POSITIVE = "jakarta.validation.constraints.Positive";
    private static final String BV_2_0_NEGATIVE_OR_ZERO = "javax.validation.constraints.NegativeOrZero";
    private static final String BV_3_0_NEGATIVE_OR_ZERO = "jakarta.validation.constraints.NegativeOrZero";
    private static final String BV_2_0_POSITIVE_OR_ZERO = "javax.validation.constraints.PositiveOrZero";
    private static final String BV_3_0_POSITIVE_OR_ZERO = "jakarta.validation.constraints.PositiveOrZero";
    private static final String BV_2_0_DIGITS = "javax.validation.constraints.Digits";
    private static final String BV_3_0_DIGITS = "jakarta.validation.constraints.Digits";
    private static final String BV_DIGITS_ATTRIBUTE_INTEGER = "integer";
    private static final String BV_DIGITS_ATTRIBUTE_FRACTION = "fraction";
    private static final String BV_2_0_PAST = "javax.validation.constraints.Past";
    private static final String BV_3_0_PAST = "jakarta.validation.constraints.Past";
    private static final String BV_2_0_FUTURE = "javax.validation.constraints.Future";
    private static final String BV_3_0_FUTURE = "jakarta.validation.constraints.Future";
    private static final String BV_2_0_PAST_OR_PRESENT = "javax.validation.constraints.PastOrPresent";
    private static final String BV_3_0_PAST_OR_PRESENT = "jakarta.validation.constraints.PastOrPresent";
    private static final String BV_2_0_FUTURE_OR_PRESENT = "javax.validation.constraints.FutureOrPresent";
    private static final String BV_3_0_FUTURE_OR_PRESENT = "jakarta.validation.constraints.FutureOrPresent";

    public static void extendWithBeanValidationInformation(OpenAPI openAPI) {
        if ((validatorJavax != null || validatorJakarta != null) && openAPI.getComponents() != null && openAPI.getComponents().getSchemas() != null) {
            openAPI.getComponents().getSchemas().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("io.domainlifecycles.spring.http.ResponseObject")).forEach(entry -> OpenAPIPropertyBeanValidationExtension.extendOpenAPISchemaForType((String)entry.getKey(), (Schema)entry.getValue()));
        }
    }

    private static void extendOpenAPISchemaForType(String fullQualifiedTypeName, Schema<?> typeSchema) {
        log.debug("Extending Open API schema for '" + fullQualifiedTypeName + "'!");
        Class<?> type = null;
        try {
            type = Thread.currentThread().getContextClassLoader().loadClass(fullQualifiedTypeName);
        }
        catch (ClassNotFoundException e) {
            log.warn("Failed to modify Open API schema for '" + fullQualifiedTypeName + "'!");
        }
        if (type != null) {
            Class<?> finalType = type;
            if (typeSchema.getProperties() != null) {
                typeSchema.getProperties().forEach((pName, pSchema) -> {
                    Field f = OpenAPIPropertyBeanValidationExtension.getFieldForTypeByPropertyName(finalType, pName);
                    if (f != null) {
                        OpenAPIPropertyBeanValidationExtension.extendSchemaForField(f, pSchema);
                    }
                });
            }
        }
    }

    private static boolean isOptional(Field field) {
        return Optional.class.isAssignableFrom(field.getType());
    }

    private static Set<javax.validation.metadata.ConstraintDescriptor<?>> getConstraintDescriptorsJavax(Field field) {
        BeanDescriptor desc = validatorJavax.getConstraintsForClass(field.getDeclaringClass());
        javax.validation.metadata.PropertyDescriptor prop = desc.getConstraintsForProperty(field.getName());
        if (prop != null) {
            if (OpenAPIPropertyBeanValidationExtension.isOptional(field)) {
                ContainerElementTypeDescriptor container = (ContainerElementTypeDescriptor)prop.getConstrainedContainerElementTypes().toArray()[0];
                return container.getConstraintDescriptors();
            }
            return prop.getConstraintDescriptors();
        }
        return null;
    }

    private static Set<ConstraintDescriptor<?>> getConstraintDescriptorsJakarta(Field field) {
        jakarta.validation.metadata.BeanDescriptor desc = validatorJakarta.getConstraintsForClass(field.getDeclaringClass());
        PropertyDescriptor prop = desc.getConstraintsForProperty(field.getName());
        if (prop != null) {
            if (OpenAPIPropertyBeanValidationExtension.isOptional(field)) {
                jakarta.validation.metadata.ContainerElementTypeDescriptor container = (jakarta.validation.metadata.ContainerElementTypeDescriptor)prop.getConstrainedContainerElementTypes().toArray()[0];
                return container.getConstraintDescriptors();
            }
            return prop.getConstraintDescriptors();
        }
        return null;
    }

    private static void extendSchemaForField(Field field, Schema<?> propertySchema) {
        Set<ConstraintDescriptor<?>> constraintDescriptors;
        Objects.requireNonNull(field, "A field must be given to extend its Open API schema!");
        Objects.requireNonNull(propertySchema, "A property schema must be given to be extended!");
        if (validatorJavax != null) {
            Set<javax.validation.metadata.ConstraintDescriptor<?>> constraintDescriptors2 = OpenAPIPropertyBeanValidationExtension.getConstraintDescriptorsJavax(field);
            if (constraintDescriptors2 != null) {
                constraintDescriptors2.forEach(cd -> OpenAPIPropertyBeanValidationExtension.extendSchemaForConstraintJavax(cd, propertySchema));
            }
        } else if (validatorJakarta != null && (constraintDescriptors = OpenAPIPropertyBeanValidationExtension.getConstraintDescriptorsJakarta(field)) != null) {
            constraintDescriptors.forEach(cd -> OpenAPIPropertyBeanValidationExtension.extendSchemaForConstraintJakarta(cd, propertySchema));
        }
    }

    private static void extendSchemaForConstraintJavax(javax.validation.metadata.ConstraintDescriptor<?> cd, Schema<?> schema) {
        switch (cd.getAnnotation().annotationType().getName()) {
            case "javax.validation.constraints.NotEmpty": {
                OpenAPIPropertyBeanValidationExtension.extendNotEmpty(schema);
                break;
            }
            case "javax.validation.constraints.NotBlank": {
                OpenAPIPropertyBeanValidationExtension.extendNotBlank(schema);
                break;
            }
            case "javax.validation.constraints.Email": {
                OpenAPIPropertyBeanValidationExtension.extendEmail(schema);
                break;
            }
            case "javax.validation.constraints.Pattern": {
                String regEx = (String)cd.getAttributes().get(BV_PATTERN_ATTRIBUTE_REGEXP);
                OpenAPIPropertyBeanValidationExtension.extendPattern(schema, regEx);
                break;
            }
            case "javax.validation.constraints.Size": {
                Integer minLengthAnnotated = (Integer)cd.getAttributes().get(BV_SIZE_ATTRIBUTE_MIN);
                Integer maxLengthAnnotated = (Integer)cd.getAttributes().get(BV_SIZE_ATTRIBUTE_MAX);
                OpenAPIPropertyBeanValidationExtension.extendSize(schema, minLengthAnnotated, maxLengthAnnotated);
                break;
            }
            case "javax.validation.constraints.Min": {
                Long minAnnotated = (Long)cd.getAttributes().get("value");
                OpenAPIPropertyBeanValidationExtension.extendMin(schema, minAnnotated);
                break;
            }
            case "javax.validation.constraints.Max": {
                Long maxAnnotated = (Long)cd.getAttributes().get("value");
                OpenAPIPropertyBeanValidationExtension.extendMax(schema, maxAnnotated);
                break;
            }
            case "javax.validation.constraints.DecimalMin": {
                String minAnnotated = (String)cd.getAttributes().get("value");
                BigDecimal bigDecimalMinAnnotated = new BigDecimal(minAnnotated);
                Boolean inclusiveAnnotated = (Boolean)cd.getAttributes().get("inclusive");
                OpenAPIPropertyBeanValidationExtension.extendDecimalMin(schema, bigDecimalMinAnnotated, inclusiveAnnotated);
                break;
            }
            case "javax.validation.constraints.DecimalMax": {
                String maxAnnotated = (String)cd.getAttributes().get("value");
                BigDecimal bigDecimalMaxAnnotated = new BigDecimal(maxAnnotated);
                Boolean inclusiveAnnotated = (Boolean)cd.getAttributes().get("inclusive");
                OpenAPIPropertyBeanValidationExtension.extendDecimalMax(schema, bigDecimalMaxAnnotated, inclusiveAnnotated);
                break;
            }
            case "javax.validation.constraints.Negative": {
                OpenAPIPropertyBeanValidationExtension.extendNegative(schema);
                break;
            }
            case "javax.validation.constraints.Positive": {
                OpenAPIPropertyBeanValidationExtension.extendPositive(schema);
                break;
            }
            case "javax.validation.constraints.NegativeOrZero": {
                OpenAPIPropertyBeanValidationExtension.extendNegativeOrZero(schema);
                break;
            }
            case "javax.validation.constraints.PositiveOrZero": {
                OpenAPIPropertyBeanValidationExtension.extendPositiveOrZero(schema);
                break;
            }
            case "javax.validation.constraints.Digits": {
                Integer integerAnnotated = (Integer)cd.getAttributes().get(BV_DIGITS_ATTRIBUTE_INTEGER);
                Integer fractionAnnotated = (Integer)cd.getAttributes().get(BV_DIGITS_ATTRIBUTE_FRACTION);
                OpenAPIPropertyBeanValidationExtension.extendDigits(schema, integerAnnotated, fractionAnnotated);
                break;
            }
            case "javax.validation.constraints.Past": {
                OpenAPIPropertyBeanValidationExtension.extendPast(schema);
                break;
            }
            case "javax.validation.constraints.Future": {
                OpenAPIPropertyBeanValidationExtension.extendFuture(schema);
                break;
            }
            case "javax.validation.constraints.PastOrPresent": {
                OpenAPIPropertyBeanValidationExtension.extendPastOrPresent(schema);
                break;
            }
            case "javax.validation.constraints.FutureOrPresent": {
                OpenAPIPropertyBeanValidationExtension.extendFutureOrPresent(schema);
            }
        }
    }

    private static void extendSchemaForConstraintJakarta(ConstraintDescriptor<?> cd, Schema<?> schema) {
        switch (cd.getAnnotation().annotationType().getName()) {
            case "jakarta.validation.constraints.NotEmpty": {
                OpenAPIPropertyBeanValidationExtension.extendNotEmpty(schema);
                break;
            }
            case "jakarta.validation.constraints.NotBlank": {
                OpenAPIPropertyBeanValidationExtension.extendNotBlank(schema);
                break;
            }
            case "jakarta.validation.constraints.Email": {
                OpenAPIPropertyBeanValidationExtension.extendEmail(schema);
                break;
            }
            case "jakarta.validation.constraints.Pattern": {
                String regEx = (String)cd.getAttributes().get(BV_PATTERN_ATTRIBUTE_REGEXP);
                OpenAPIPropertyBeanValidationExtension.extendPattern(schema, regEx);
                break;
            }
            case "jakarta.validation.constraints.Size": {
                Integer minLengthAnnotated = (Integer)cd.getAttributes().get(BV_SIZE_ATTRIBUTE_MIN);
                Integer maxLengthAnnotated = (Integer)cd.getAttributes().get(BV_SIZE_ATTRIBUTE_MAX);
                OpenAPIPropertyBeanValidationExtension.extendSize(schema, minLengthAnnotated, maxLengthAnnotated);
                break;
            }
            case "jakarta.validation.constraints.Min": {
                Long minAnnotated = (Long)cd.getAttributes().get("value");
                OpenAPIPropertyBeanValidationExtension.extendMin(schema, minAnnotated);
                break;
            }
            case "jakarta.validation.constraints.Max": {
                Long maxAnnotated = (Long)cd.getAttributes().get("value");
                OpenAPIPropertyBeanValidationExtension.extendMax(schema, maxAnnotated);
                break;
            }
            case "jakarta.validation.constraints.DecimalMin": {
                String minAnnotated = (String)cd.getAttributes().get("value");
                BigDecimal bigDecimalMinAnnotated = new BigDecimal(minAnnotated);
                Boolean inclusiveAnnotated = (Boolean)cd.getAttributes().get("inclusive");
                OpenAPIPropertyBeanValidationExtension.extendDecimalMin(schema, bigDecimalMinAnnotated, inclusiveAnnotated);
                break;
            }
            case "jakarta.validation.constraints.DecimalMax": {
                String maxAnnotated = (String)cd.getAttributes().get("value");
                BigDecimal bigDecimalMaxAnnotated = new BigDecimal(maxAnnotated);
                Boolean inclusiveAnnotated = (Boolean)cd.getAttributes().get("inclusive");
                OpenAPIPropertyBeanValidationExtension.extendDecimalMax(schema, bigDecimalMaxAnnotated, inclusiveAnnotated);
                break;
            }
            case "jakarta.validation.constraints.Negative": {
                OpenAPIPropertyBeanValidationExtension.extendNegative(schema);
                break;
            }
            case "jakarta.validation.constraints.Positive": {
                OpenAPIPropertyBeanValidationExtension.extendPositive(schema);
                break;
            }
            case "jakarta.validation.constraints.NegativeOrZero": {
                OpenAPIPropertyBeanValidationExtension.extendNegativeOrZero(schema);
                break;
            }
            case "jakarta.validation.constraints.PositiveOrZero": {
                OpenAPIPropertyBeanValidationExtension.extendPositiveOrZero(schema);
                break;
            }
            case "jakarta.validation.constraints.Digits": {
                Integer integerAnnotated = (Integer)cd.getAttributes().get(BV_DIGITS_ATTRIBUTE_INTEGER);
                Integer fractionAnnotated = (Integer)cd.getAttributes().get(BV_DIGITS_ATTRIBUTE_FRACTION);
                OpenAPIPropertyBeanValidationExtension.extendDigits(schema, integerAnnotated, fractionAnnotated);
                break;
            }
            case "jakarta.validation.constraints.Past": {
                OpenAPIPropertyBeanValidationExtension.extendPast(schema);
                break;
            }
            case "jakarta.validation.constraints.Future": {
                OpenAPIPropertyBeanValidationExtension.extendFuture(schema);
                break;
            }
            case "jakarta.validation.constraints.PastOrPresent": {
                OpenAPIPropertyBeanValidationExtension.extendPastOrPresent(schema);
                break;
            }
            case "jakarta.validation.constraints.FutureOrPresent": {
                OpenAPIPropertyBeanValidationExtension.extendFutureOrPresent(schema);
            }
        }
    }

    private static void extendNotEmpty(Schema<?> schema) {
        if ("string".equals(schema.getType())) {
            if (schema.getMinLength() == null || schema.getMinLength() < 1) {
                schema.setMinLength(Integer.valueOf(1));
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationNotEmpty", schema, new String[0]);
        } else if ("array".equals(schema.getType())) {
            if (schema.getMinItems() == null || schema.getMinItems() < 1) {
                schema.setMinItems(Integer.valueOf(1));
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationNotEmpty", schema, new String[0]);
        }
    }

    private static void extendNotBlank(Schema<?> schema) {
        if ("string".equals(schema.getType())) {
            if (schema.getMinLength() == null || schema.getMinLength() < 1) {
                schema.setMinLength(Integer.valueOf(1));
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationNotBlank", schema, new String[0]);
        }
    }

    private static void extendEmail(Schema<?> schema) {
        if ("string".equals(schema.getType())) {
            if (schema.getFormat() == null) {
                schema.setFormat("email");
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationEmail", schema, new String[0]);
        }
    }

    private static void extendPattern(Schema<?> schema, String regEx) {
        if ("string".equals(schema.getType())) {
            if (schema.getPattern() == null) {
                schema.setPattern(regEx);
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationPattern", schema, new String[0]);
        }
    }

    private static void extendSize(Schema<?> schema, Integer minLengthAnnotated, Integer maxLengthAnnotated) {
        if ("string".equals(schema.getType())) {
            if (schema.getMinLength() == null || schema.getMinLength() < minLengthAnnotated) {
                schema.setMinLength(minLengthAnnotated);
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationSizeMin", schema, minLengthAnnotated.toString());
            if (schema.getMaxLength() == null || schema.getMaxLength() > maxLengthAnnotated) {
                schema.setMaxLength(maxLengthAnnotated);
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationSizeMax", schema, maxLengthAnnotated.toString());
        } else if ("array".equals(schema.getType())) {
            if (schema.getMinItems() == null || schema.getMinItems() < minLengthAnnotated) {
                schema.setMinItems(minLengthAnnotated);
            }
            if (schema.getMaxItems() == null || schema.getMaxItems() > maxLengthAnnotated) {
                schema.setMaxItems(maxLengthAnnotated);
            }
        }
    }

    private static void extendMin(Schema<?> schema, Long minAnnotated) {
        if ("number".equals(schema.getType()) || BV_DIGITS_ATTRIBUTE_INTEGER.equals(schema.getType()) || "string".equals(schema.getType()) && "byte".equals(schema.getFormat())) {
            if (schema.getMinimum() == null || (long)schema.getMinimum().intValue() < minAnnotated) {
                schema.setMinimum(BigDecimal.valueOf(minAnnotated));
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationDecimalMin", schema, minAnnotated.toString());
        }
    }

    private static void extendMax(Schema<?> schema, Long maxAnnotated) {
        if ("number".equals(schema.getType()) || BV_DIGITS_ATTRIBUTE_INTEGER.equals(schema.getType()) || "string".equals(schema.getType()) && "byte".equals(schema.getFormat())) {
            if (schema.getMaximum() == null || (long)schema.getMaximum().intValue() > maxAnnotated) {
                schema.setMaximum(BigDecimal.valueOf(maxAnnotated));
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationDecimalMax", schema, maxAnnotated.toString());
        }
    }

    private static void extendDecimalMin(Schema<?> schema, BigDecimal bigDecimalMinAnnotated, Boolean inclusiveAnnotated) {
        if ("number".equals(schema.getType()) || BV_DIGITS_ATTRIBUTE_INTEGER.equals(schema.getType()) || "string".equals(schema.getType()) && "byte".equals(schema.getFormat())) {
            if (schema.getMinimum() == null || schema.getMinimum().compareTo(bigDecimalMinAnnotated) < 0) {
                schema.setMinimum(bigDecimalMinAnnotated);
            }
            if (!inclusiveAnnotated.booleanValue()) {
                schema.setExclusiveMinimum(Boolean.valueOf(true));
                OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationDecimalMin", schema, bigDecimalMinAnnotated.toPlainString());
            } else {
                OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationDecimalMinInclusive", schema, bigDecimalMinAnnotated.toPlainString());
            }
        }
    }

    private static void extendDecimalMax(Schema<?> schema, BigDecimal bigDecimalMaxAnnotated, Boolean inclusiveAnnotated) {
        if ("number".equals(schema.getType()) || BV_DIGITS_ATTRIBUTE_INTEGER.equals(schema.getType()) || "string".equals(schema.getType()) && "byte".equals(schema.getFormat())) {
            if (schema.getMaximum() == null || schema.getMaximum().compareTo(bigDecimalMaxAnnotated) > 0) {
                schema.setMaximum(bigDecimalMaxAnnotated);
            }
            if (!inclusiveAnnotated.booleanValue()) {
                schema.setExclusiveMaximum(Boolean.valueOf(true));
                OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationDecimalMax", schema, bigDecimalMaxAnnotated.toPlainString());
            } else {
                OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationDecimalMaxInclusive", schema, bigDecimalMaxAnnotated.toPlainString());
            }
        }
    }

    private static void extendNegative(Schema<?> schema) {
        if ("number".equals(schema.getType()) || BV_DIGITS_ATTRIBUTE_INTEGER.equals(schema.getType()) || "string".equals(schema.getType()) && "byte".equals(schema.getFormat())) {
            if (schema.getMaximum() == null || schema.getMaximum().intValue() > 0) {
                schema.setMaximum(BigDecimal.valueOf(0L));
                schema.setExclusiveMaximum(Boolean.valueOf(true));
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationNegative", schema, new String[0]);
        }
    }

    private static void extendPositive(Schema<?> schema) {
        if ("number".equals(schema.getType()) || BV_DIGITS_ATTRIBUTE_INTEGER.equals(schema.getType()) || "string".equals(schema.getType()) && "byte".equals(schema.getFormat())) {
            if (schema.getMinimum() == null || schema.getMinimum().intValue() < 0) {
                schema.setMinimum(BigDecimal.valueOf(0L));
                schema.setExclusiveMinimum(Boolean.valueOf(true));
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationPositive", schema, new String[0]);
        }
    }

    private static void extendNegativeOrZero(Schema<?> schema) {
        if ("number".equals(schema.getType()) || BV_DIGITS_ATTRIBUTE_INTEGER.equals(schema.getType()) || "string".equals(schema.getType()) && "byte".equals(schema.getFormat())) {
            if (schema.getMaximum() == null || schema.getMaximum().intValue() > 0) {
                schema.setMaximum(BigDecimal.valueOf(0L));
                schema.setExclusiveMaximum(Boolean.valueOf(false));
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationNegativeOrZero", schema, new String[0]);
        }
    }

    private static void extendPositiveOrZero(Schema<?> schema) {
        if ("number".equals(schema.getType()) || BV_DIGITS_ATTRIBUTE_INTEGER.equals(schema.getType()) || "string".equals(schema.getType()) && "byte".equals(schema.getFormat())) {
            if (schema.getMinimum() == null || schema.getMinimum().intValue() < 0) {
                schema.setMinimum(BigDecimal.valueOf(0L));
                schema.setExclusiveMinimum(Boolean.valueOf(false));
            }
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationPositiveOrZero", schema, new String[0]);
        }
    }

    private static void extendDigits(Schema<?> schema, Integer integerAnnotated, Integer fractionAnnotated) {
        if ("number".equals(schema.getType()) || BV_DIGITS_ATTRIBUTE_INTEGER.equals(schema.getType()) || "string".equals(schema.getType()) && "byte".equals(schema.getFormat())) {
            if (integerAnnotated < 1) {
                log.warn("Annotating the integer part of '" + schema.getName() + "' with a value < 1 makes no sense!");
            }
            if (schema.getPattern() == null) {
                String pattern;
                String patternInteger = "[-]?[1-9]{1,1}[0-9]{0," + (integerAnnotated - 1) + "}|[0]";
                String patternIntegerZeroNegativeOption = "|[-][0]";
                String patternFraction = "[0-9]{1," + fractionAnnotated + "}";
                String patternSeparator = "\\.";
                if (BV_DIGITS_ATTRIBUTE_INTEGER.equals(schema.getType()) || "string".equals(schema.getType()) && "byte".equals(schema.getFormat())) {
                    pattern = "^" + patternInteger + "$";
                } else if (fractionAnnotated > 0) {
                    pattern = "^(" + patternInteger + patternIntegerZeroNegativeOption + "){1,1}(" + patternSeparator + patternFraction + ")?$";
                    OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationDigitsIntegerFraction", schema, integerAnnotated.toString(), fractionAnnotated.toString());
                } else {
                    pattern = "^" + patternInteger + "$";
                    OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationDigitsInteger", schema, integerAnnotated.toString());
                }
                schema.setPattern(pattern);
            }
        }
    }

    private static void extendPast(Schema<?> schema) {
        if (OpenAPIPropertyBeanValidationExtension.isTemporalType(schema)) {
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationPast", schema, new String[0]);
        }
    }

    private static void extendPastOrPresent(Schema<?> schema) {
        if (OpenAPIPropertyBeanValidationExtension.isTemporalType(schema)) {
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationPastOrPresent", schema, new String[0]);
        }
    }

    private static void extendFuture(Schema<?> schema) {
        if (OpenAPIPropertyBeanValidationExtension.isTemporalType(schema)) {
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationFuture", schema, new String[0]);
        }
    }

    private static void extendFutureOrPresent(Schema<?> schema) {
        if (OpenAPIPropertyBeanValidationExtension.isTemporalType(schema)) {
            OpenAPIPropertyBeanValidationExtension.addSchemaDescription("beanValidationFutureOrPresent", schema, new String[0]);
        }
    }

    private static boolean isTemporalType(Schema<?> schema) {
        return "string".equals(schema.getType()) && ("date".equals(schema.getFormat()) || "date-time".equals(schema.getFormat())) || "#/components/schemas/java.time.LocalTime".equals(schema.get$ref()) || "#/components/schemas/java.time.OffsetTime".equals(schema.get$ref()) || "#/components/schemas/java.time.YearMonth".equals(schema.get$ref()) || "#/components/schemas/java.time.MonthDay".equals(schema.get$ref()) || "#/components/schemas/java.time.Year".equals(schema.get$ref());
    }

    private static Field getFieldForTypeByPropertyName(Class<?> type, String propertyName) {
        Field[] fieldCandidates = (Field[])JavaReflect.fields(type, (MemberSelect)MemberSelect.HIERARCHY).stream().filter(f -> !Modifier.isStatic(f.getModifiers()) && f.getName().equals(propertyName)).toArray(Field[]::new);
        if (fieldCandidates.length == 0) {
            fieldCandidates = (Field[])JavaReflect.fields(type, (MemberSelect)MemberSelect.HIERARCHY).stream().filter(f -> !Modifier.isStatic(f.getModifiers()) && f.getName().equalsIgnoreCase(propertyName)).toArray(Field[]::new);
            if (fieldCandidates.length == 0) {
                log.warn("Failed to modify Open API schema for property '" + propertyName + "' within '" + type.getName() + "'! Field not found!");
                return null;
            }
            if (fieldCandidates.length > 1) {
                log.warn("When modifying Open API schema for property '" + propertyName + "' within '" + type.getName() + "'! Multiple filed candidates found (ignoring case), returning first hit!");
            }
        } else if (fieldCandidates.length > 1) {
            log.warn("When modifying Open API schema for property '" + propertyName + "' within '" + type.getName() + "'! Multiple filed candidates found, returning first hit!");
        }
        return fieldCandidates[0];
    }

    private static void addSchemaDescription(String bundleKey, Schema<?> schema, String ... replacement) {
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle(ResourceBundle.class.getName(), Locale.getDefault());
        if (schema.getDescription() == null) {
            schema.setDescription(String.format(bundle.getString(bundleKey), replacement));
        } else {
            String newDesc = String.format(bundle.getString(bundleKey), replacement);
            if (!schema.getDescription().contains(newDesc)) {
                schema.setDescription(schema.getDescription() + " " + newDesc);
            }
        }
    }

    static {
        try {
            validatorJavax = javax.validation.Validation.buildDefaultValidatorFactory().getValidator();
            log.info("Bean validation 2.0 supported!");
        }
        catch (Throwable t) {
            validatorJavax = null;
            log.info("No bean validation 2.0 provider found or validation factory could not be built. Bean validation 2.0 extensions are disabled!");
        }
        try {
            validatorJakarta = Validation.buildDefaultValidatorFactory().getValidator();
            log.info("Bean validation 3.0 supported!");
        }
        catch (Throwable t) {
            validatorJakarta = null;
            log.info("No bean validation provider 3.0 found or validation factory could not be built. Bean validation 3.0 extensions are disabled!");
        }
    }
}

