/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.swagger.v3;

import io.domainlifecycles.reflect.JavaReflect;
import io.domainlifecycles.reflect.MemberSelect;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIPrimitivePropertyExtension {
    private static final Logger log = LoggerFactory.getLogger(OpenAPIPrimitivePropertyExtension.class);

    public static void extendPrimitiveProperties(OpenAPI openAPI) {
        if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() != null) {
            openAPI.getComponents().getSchemas().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("io.domainlifecycles.spring.http.ResponseObject")).forEach(entry -> OpenAPIPrimitivePropertyExtension.extendOpenAPISchemaForPrimitivePropertyTypes((String)entry.getKey(), (Schema)entry.getValue()));
        }
    }

    private static void extendOpenAPISchemaForPrimitivePropertyTypes(String fullQualifiedTypeName, Schema<?> typeSchema) {
        log.debug("Extending Open API schema for '" + fullQualifiedTypeName + "'!");
        Class<?> type = null;
        try {
            type = Thread.currentThread().getContextClassLoader().loadClass(fullQualifiedTypeName);
        }
        catch (ClassNotFoundException e) {
            log.warn("Failed to modify Open API schema for '" + fullQualifiedTypeName + "'!");
        }
        if (type != null) {
            Class<?> finalType = type;
            if (typeSchema.getProperties() != null) {
                typeSchema.getProperties().forEach((pName, pSchema) -> {
                    Field f = OpenAPIPrimitivePropertyExtension.getFieldForTypeByPropertyName(finalType, pName);
                    if (f != null && f.getType().isPrimitive()) {
                        if (typeSchema.getRequired() == null) {
                            ArrayList<String> reqList = new ArrayList<String>();
                            reqList.add((String)pName);
                            typeSchema.setRequired(reqList);
                        } else {
                            typeSchema.getRequired().add(pName);
                        }
                    }
                });
            }
        }
    }

    private static Field getFieldForTypeByPropertyName(Class<?> type, String propertyName) {
        Field[] fieldCandidates = (Field[])JavaReflect.fields(type, (MemberSelect)MemberSelect.HIERARCHY).stream().filter(f -> !Modifier.isStatic(f.getModifiers()) && f.getName().equals(propertyName)).toArray(Field[]::new);
        if (fieldCandidates.length == 0) {
            fieldCandidates = (Field[])JavaReflect.fields(type, (MemberSelect)MemberSelect.HIERARCHY).stream().filter(f -> !Modifier.isStatic(f.getModifiers()) && f.getName().equalsIgnoreCase(propertyName)).toArray(Field[]::new);
            if (fieldCandidates.length == 0) {
                log.warn("Failed to modify Open API schema for property '" + propertyName + "' within '" + type.getName() + "'! Field not found!");
                return null;
            }
            if (fieldCandidates.length > 1) {
                log.warn("When modifying Open API schema for property '" + propertyName + "' within '" + type.getName() + "'! Multiple filed candidates found (ignoring case), returning first hit!");
            }
        } else if (fieldCandidates.length > 1) {
            log.warn("When modifying Open API schema for property '" + propertyName + "' within '" + type.getName() + "'! Multiple filed candidates found, returning first hit!");
        }
        return fieldCandidates[0];
    }
}

