/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.swagger.v3;

import io.domainlifecycles.access.DlcAccess;
import io.domainlifecycles.mirror.api.Domain;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.EntityMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.IdentityMirror;
import io.domainlifecycles.mirror.api.ValueMirror;
import io.domainlifecycles.mirror.api.ValueObjectMirror;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorBasedOpenApiExtension {
    private static final Logger log = LoggerFactory.getLogger(MirrorBasedOpenApiExtension.class);

    public void extendOpenAPISchemaForDLCTypes(OpenAPI openAPI, String ... entitiesWithExternallyProvidedIds) {
        if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() != null) {
            openAPI.getComponents().getSchemas().forEach((typeName, typeSchema) -> {
                Optional tm = Domain.typeMirror((String)typeName);
                if (tm.isPresent() && DomainType.IDENTITY.equals((Object)((DomainTypeMirror)tm.get()).getDomainType())) {
                    IdentityMirror idm = (IdentityMirror)tm.get();
                    this.extendSchemaOfIdentityType(idm, (Schema<?>)typeSchema);
                }
            });
            this.modifyEntitySchemata(openAPI, entitiesWithExternallyProvidedIds);
            this.modifyValueObjectSchemata(openAPI);
            this.modifyParameters(openAPI);
            this.modifyExternalDomainObjectReferences(openAPI);
        }
    }

    private void extendSchemaOfIdentityType(IdentityMirror identityMirror, Schema<?> domainObjectSchema) {
        try {
            if (identityMirror.getValueTypeName().isPresent()) {
                ModelConverters mcInstance = ModelConverters.getInstance();
                String valueTypeName = (String)identityMirror.getValueTypeName().get();
                Class valueTypeClass = DlcAccess.getClassForName((String)valueTypeName);
                ResolvedSchema idValueSchema = mcInstance.resolveAsResolvedSchema(new AnnotatedType().type((Type)valueTypeClass));
                HashMap<String, Schema> propertiesMap = new HashMap<String, Schema>();
                String fieldName = ((FieldMirror)identityMirror.getAllFields().get(0)).getName();
                propertiesMap.put(fieldName, idValueSchema.schema.name(fieldName));
                domainObjectSchema.setProperties(propertiesMap);
                domainObjectSchema.setRequired(List.of(fieldName));
            } else {
                log.warn("Wasn't able to extend Identity Open API schema of '{}'! Identity value field not found!", (Object)identityMirror.getTypeName());
            }
        }
        catch (Throwable t) {
            log.warn("Extending Open API schema of identity type '{}' failed", (Object)identityMirror.getTypeName(), (Object)t);
        }
    }

    private void modifyEntitySchemata(OpenAPI openAPI, String ... entitiesWithExternallyProvidedIds) {
        Domain.getInitializedDomain().allTypeMirrors().values().stream().filter(dtm -> DomainType.ENTITY.equals((Object)dtm.getDomainType()) || DomainType.AGGREGATE_ROOT.equals((Object)dtm.getDomainType())).map(dtm -> (EntityMirror)dtm).forEach(em -> {
            try {
                String entityFqn = em.getTypeName();
                Map schemas = openAPI.getComponents().getSchemas();
                Schema entitySchema = (Schema)schemas.get(entityFqn);
                if (entitySchema != null) {
                    if (em.getIdentityField().isPresent()) {
                        FieldMirror idField = (FieldMirror)em.getIdentityField().get();
                        if (entitySchema.getRequired() != null && Arrays.stream(entitiesWithExternallyProvidedIds).noneMatch(fqn -> fqn.equals(em.getTypeName()))) {
                            entitySchema.getRequired().remove(idField.getName());
                        }
                        this.modifyIdentitySchemaReference(openAPI, idField.getName(), idField.getType().getTypeName(), entitySchema);
                    }
                    em.getValueReferences().stream().filter(vrm -> !vrm.isStatic()).filter(vrm -> vrm.getValue().isSingledValued() && !vrm.getValue().isEnum()).forEach(vrm -> {
                        ValueMirror vm = vrm.getValue();
                        if (vm.isValueObject()) {
                            this.modifySingleValuedValueObjectSchemaReference(openAPI, vrm.getName(), vrm.getType().getTypeName(), entitySchema);
                        } else {
                            this.modifyIdentitySchemaReference(openAPI, vrm.getName(), vrm.getType().getTypeName(), entitySchema);
                        }
                    });
                }
            }
            catch (Throwable t) {
                log.warn("Extending Open API schema of entity type '{}' failed", (Object)em.getTypeName(), (Object)t);
            }
        });
    }

    private void modifyValueObjectSchemata(OpenAPI openAPI) {
        Domain.getInitializedDomain().allTypeMirrors().values().stream().filter(dtm -> DomainType.VALUE_OBJECT.equals((Object)dtm.getDomainType())).map(dtm -> (ValueObjectMirror)dtm).forEach(vo -> {
            try {
                String voFqn = vo.getTypeName();
                Map schemas = openAPI.getComponents().getSchemas();
                Schema voSchema = (Schema)schemas.get(voFqn);
                if (voSchema != null) {
                    vo.getValueReferences().stream().filter(vrm -> !vrm.isStatic()).filter(vrm -> vrm.getValue().isValueObject() || vrm.getValue().isIdentity()).forEach(vrm -> {
                        if (vrm.getValue().isValueObject()) {
                            ValueMirror vm = vrm.getValue();
                            if (vm.isSingledValued()) {
                                this.modifySingleValuedValueObjectSchemaReference(openAPI, vrm.getName(), vrm.getType().getTypeName(), voSchema);
                            }
                        } else {
                            this.modifyIdentitySchemaReference(openAPI, vrm.getName(), vrm.getType().getTypeName(), voSchema);
                        }
                    });
                }
            }
            catch (Throwable t) {
                log.warn("Extending Open API schema of value object type '{}' failed", (Object)vo.getTypeName(), (Object)t);
            }
        });
    }

    private void modifyIdentitySchemaReference(OpenAPI openAPI, String propertyName, String propertyIdentityTypeName, Schema<?> targetSchema) {
        Optional idValueSchema;
        Schema identitySchema = (Schema)openAPI.getComponents().getSchemas().get(propertyIdentityTypeName);
        if (identitySchema != null && identitySchema.getProperties() != null && (idValueSchema = identitySchema.getProperties().values().stream().findFirst()).isPresent()) {
            Schema<?> newIdentityPropertySchema = this.copyValueSchema((Schema)idValueSchema.get(), targetSchema.getName() + "." + propertyName);
            if (targetSchema.getProperties() != null) {
                Schema currentValueSchema = (Schema)targetSchema.getProperties().get(propertyName);
                if ("array".equals(currentValueSchema.getType())) {
                    currentValueSchema.setItems(newIdentityPropertySchema);
                } else {
                    targetSchema.getProperties().put(propertyName, newIdentityPropertySchema);
                }
                return;
            }
        }
        log.warn("Wasn't able to set correct value type for property '" + propertyName + "' on schema'" + targetSchema.getName() + "'!");
    }

    private void modifySingleValuedValueObjectSchemaReference(OpenAPI openAPI, String voReferencePropertyName, String voTypeName, Schema<?> targetSchema) {
        Optional valueSchema;
        Schema valueObjectSchema = (Schema)openAPI.getComponents().getSchemas().get(voTypeName);
        if (valueObjectSchema != null && valueObjectSchema.getProperties() != null && (valueSchema = valueObjectSchema.getProperties().values().stream().findFirst()).isPresent()) {
            Schema<?> newValueSchema = this.copyValueSchema((Schema)valueSchema.get(), targetSchema.getName() + "." + voReferencePropertyName);
            if (targetSchema.getProperties() != null) {
                Schema currentValueSchema = (Schema)targetSchema.getProperties().get(voReferencePropertyName);
                if (currentValueSchema != null) {
                    if ("array".equals(currentValueSchema.getType())) {
                        currentValueSchema.setItems(newValueSchema);
                    } else {
                        targetSchema.getProperties().put(voReferencePropertyName, newValueSchema);
                    }
                }
                return;
            }
        }
        log.warn("Wasn't able to set correct value type for property '" + voReferencePropertyName + "' on '" + voTypeName + "'!");
    }

    private Schema<?> copyValueSchema(Schema<?> source, String newName) {
        Schema newSchema = new Schema();
        newSchema.setName(newName);
        newSchema.setType(source.getType());
        newSchema.setPattern(source.getPattern());
        newSchema.setDescription(source.getDescription());
        newSchema.setFormat(source.getFormat());
        if (source.getExample() != null) {
            newSchema.setExample(source.getExample());
        }
        newSchema.setExclusiveMinimum(source.getExclusiveMinimum());
        newSchema.setExclusiveMaximum(source.getExclusiveMaximum());
        newSchema.setMinimum(source.getMinimum());
        newSchema.setMaximum(source.getMaximum());
        newSchema.setDefault(source.getDefault());
        newSchema.setMaxLength(source.getMaxLength());
        newSchema.setMinLength(source.getMinLength());
        newSchema.setJsonSchema(source.getJsonSchema());
        return newSchema;
    }

    private void modifyParameters(OpenAPI openAPI) {
        openAPI.getPaths().values().forEach(pathItem -> {
            List ops = pathItem.readOperations();
            if (ops != null) {
                ops.forEach(op -> {
                    List parameters = op.getParameters();
                    if (parameters != null) {
                        parameters.forEach(param -> this.modifyParam((Parameter)param, openAPI));
                    }
                });
            }
        });
    }

    private void modifyParam(Parameter param, OpenAPI openAPI) {
        String ref = param.getSchema().get$ref();
        if ("array".equals(param.getSchema().getType())) {
            ref = param.getSchema().getItems().get$ref();
        }
        if (ref != null) {
            String referencedTypeFqn = ref.substring(ref.lastIndexOf("/") + 1);
            Schema refTypeSchema = (Schema)openAPI.getComponents().getSchemas().get(referencedTypeFqn);
            Optional dtmOptional = Domain.typeMirror((String)referencedTypeFqn);
            if (dtmOptional.isPresent()) {
                DomainTypeMirror dtm = (DomainTypeMirror)dtmOptional.get();
                if (DomainType.VALUE_OBJECT.equals((Object)dtm.getDomainType())) {
                    ValueObjectMirror vo = (ValueObjectMirror)dtm;
                    if (vo.isSingledValued()) {
                        this.modifySingleValuedTypeSchema(param, refTypeSchema, referencedTypeFqn);
                    }
                } else if (DomainType.IDENTITY.equals((Object)dtm.getDomainType())) {
                    this.modifySingleValuedTypeSchema(param, refTypeSchema, referencedTypeFqn);
                }
            } else {
                log.warn("Wasn't able to modify param schema for '{}'!", (Object)referencedTypeFqn);
            }
        }
    }

    private void modifySingleValuedTypeSchema(Parameter param, Schema<?> refTypeSchema, String referencedTypeFqn) {
        Optional propSchema;
        if (refTypeSchema.getProperties() != null && (propSchema = refTypeSchema.getProperties().values().stream().findFirst()).isPresent()) {
            Schema<?> newSchema = this.copyValueSchema((Schema)propSchema.get(), param.getName() + "." + refTypeSchema.getName());
            if ("array".equals(param.getSchema().getType())) {
                param.getSchema().setItems(newSchema);
            } else {
                param.schema(newSchema);
            }
            return;
        }
        log.warn("Wasn't able to modify param schema for '{}'!", (Object)referencedTypeFqn);
    }

    private void modifyExternalDomainObjectReferences(OpenAPI openAPI) {
        openAPI.getComponents().getSchemas().forEach((typeName, typeSchema) -> {
            Optional dtmOptional = Domain.typeMirror((String)typeName);
            if (dtmOptional.isEmpty() && typeSchema.getProperties() != null) {
                typeSchema.getProperties().forEach((n, p) -> {
                    String pName = (String)n;
                    Schema pSchema = (Schema)p;
                    this.modifyExternalDomainReferenceSchema(openAPI, pName, (Schema<?>)pSchema, (Schema<?>)typeSchema);
                });
            }
        });
    }

    private void modifyExternalDomainReferenceSchema(OpenAPI openAPI, String propertyName, Schema<?> propertySchema, Schema<?> containerSchema) {
        String propTypeName;
        Optional dtmOptional;
        Schema pSchema = propertySchema;
        if ("array".equals(pSchema.getType())) {
            pSchema = propertySchema.getItems();
        }
        if (pSchema.get$ref() != null && (dtmOptional = Domain.typeMirror((String)(propTypeName = pSchema.get$ref().substring("#/components/schemas/".length())))).isPresent()) {
            ValueObjectMirror voMirror;
            DomainTypeMirror dtm = (DomainTypeMirror)dtmOptional.get();
            if (DomainType.IDENTITY.equals((Object)dtm.getDomainType())) {
                this.modifyIdentitySchemaReference(openAPI, propertyName, propTypeName, containerSchema);
            } else if (DomainType.VALUE_OBJECT.equals((Object)dtm.getDomainType()) && (voMirror = Domain.valueObjectMirrorFor((String)propTypeName)).isSingledValued()) {
                this.modifySingleValuedValueObjectSchemaReference(openAPI, propertyName, propTypeName, containerSchema);
            }
        }
    }
}

