/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.spring.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.domainlifecycles.domain.types.ValueObject;
import io.domainlifecycles.mirror.api.Domain;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.ValueObjectMirror;
import java.util.Optional;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;

public class StringToDomainValueObjectConverterFactory
implements ConverterFactory<String, ValueObject> {
    private final ObjectMapper objectMapper;

    public StringToDomainValueObjectConverterFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T extends ValueObject> Converter<String, T> getConverter(Class<T> targetClass) {
        return new StringToDomainValueObjectConverter<T>(targetClass, this.objectMapper);
    }

    private record StringToDomainValueObjectConverter<T extends ValueObject>(Class<T> targetClass, ObjectMapper objectMapper) implements Converter<String, T>
    {
        public T convert(String source) {
            ValueObjectMirror voMirror = Domain.valueObjectMirrorFor((String)this.targetClass.getName());
            Optional singleValuedField = voMirror.singledValuedField();
            if (singleValuedField.isPresent()) {
                try {
                    return (T)((ValueObject)this.objectMapper.readValue("{\"" + ((FieldMirror)singleValuedField.get()).getName() + "\": \"" + source + "\"}", this.targetClass));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(String.format("Not able to parse single property value of ValueObject '%s'", this.targetClass.getName()), e);
                }
            }
            throw new RuntimeException("Could not map value object of type " + this.targetClass.getName() + " from String value '" + source + "'. Please provide a custom converter of type 'org.springframework.core.convert.converter.Converter'!");
        }
    }
}

